/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.matcher;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.ConditionMatcher;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.pattern.ValuePattern;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.support.RpcUtils;

public abstract class AbstractConditionMatcher
implements ConditionMatcher {
    public static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractConditionMatcher.class);
    public static final String DOES_NOT_FOUND_VALUE = "dubbo_internal_not_found_argument_condition_value";
    final Set<String> matches = new HashSet<String>();
    final Set<String> mismatches = new HashSet<String>();
    private final ModuleModel model;
    private final List<ValuePattern> valueMatchers;
    protected final String key;

    public AbstractConditionMatcher(String key, ModuleModel model) {
        this.key = key;
        this.model = model;
        this.valueMatchers = model.getExtensionLoader(ValuePattern.class).getActivateExtensions();
    }

    public static String getSampleValueFromUrl(String conditionKey, Map<String, String> sample, URL param, Invocation invocation) {
        String sampleValue = invocation != null && ("method".equals(conditionKey) || "methods".equals(conditionKey)) ? RpcUtils.getMethodName((Invocation)invocation) : sample.get(conditionKey);
        return sampleValue;
    }

    @Override
    public boolean isMatch(Map<String, String> sample, URL param, Invocation invocation, boolean isWhenCondition) {
        String value = this.getValue(sample, param, invocation);
        if (value == null) {
            return false;
        }
        if (!this.matches.isEmpty() && this.mismatches.isEmpty()) {
            for (String match : this.matches) {
                if (!this.doPatternMatch(match, value, param, invocation, isWhenCondition)) continue;
                return true;
            }
            return false;
        }
        if (!this.mismatches.isEmpty() && this.matches.isEmpty()) {
            for (String mismatch : this.mismatches) {
                if (!this.doPatternMatch(mismatch, value, param, invocation, isWhenCondition)) continue;
                return false;
            }
            return true;
        }
        if (!this.matches.isEmpty() && !this.mismatches.isEmpty()) {
            for (String mismatch : this.mismatches) {
                if (!this.doPatternMatch(mismatch, value, param, invocation, isWhenCondition)) continue;
                return false;
            }
            for (String match : this.matches) {
                if (!this.doPatternMatch(match, value, param, invocation, isWhenCondition)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Set<String> getMatches() {
        return this.matches;
    }

    @Override
    public Set<String> getMismatches() {
        return this.mismatches;
    }

    protected boolean doPatternMatch(String pattern, String value, URL url, Invocation invocation, boolean isWhenCondition) {
        for (ValuePattern valueMatcher : this.valueMatchers) {
            if (!valueMatcher.shouldMatch(pattern)) continue;
            return valueMatcher.match(pattern, value, url, invocation, isWhenCondition);
        }
        logger.error("2-7", "Executing condition rule value match expression error.", "pattern is " + pattern + ", value is " + value + ", condition type " + (isWhenCondition ? "when" : "then"), "There should at least has one ValueMatcher instance that applies to all patterns, will force to use wildcard matcher now.");
        ValuePattern paramValueMatcher = (ValuePattern)this.model.getExtensionLoader(ValuePattern.class).getExtension("wildcard");
        return paramValueMatcher.match(pattern, value, url, invocation, isWhenCondition);
    }

    protected abstract String getValue(Map<String, String> var1, URL var2, Invocation var3);
}

