/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.affinity;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.ConditionMatcher;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.ConditionMatcherFactory;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class AffinityStateRouter<T>
extends AbstractStateRouter<T> {
    public static final String NAME = "affinity";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractStateRouter.class);
    protected String affinityKey;
    protected Double ratio;
    protected ConditionMatcher matchMatcher;
    protected List<ConditionMatcherFactory> matcherFactories;
    private final boolean enabled;

    public AffinityStateRouter(URL url) {
        super(url);
        this.enabled = url.getParameter("enabled", true);
        this.affinityKey = url.getParameter("affinityAware", "");
        this.ratio = url.getParameter("ratio", 0.0);
        this.matcherFactories = this.moduleModel.getExtensionLoader(ConditionMatcherFactory.class).getActivateExtensions();
        if (this.enabled) {
            this.init(this.affinityKey);
        }
    }

    public AffinityStateRouter(URL url, String affinityKey, Double ratio, boolean enabled) {
        super(url);
        this.enabled = enabled;
        this.affinityKey = affinityKey;
        this.ratio = ratio;
        this.matcherFactories = this.moduleModel.getExtensionLoader(ConditionMatcherFactory.class).getActivateExtensions();
        if (this.enabled) {
            this.init(affinityKey);
        }
    }

    public void init(String rule) {
        try {
            if (rule == null || rule.trim().isEmpty()) {
                throw new IllegalArgumentException("Illegal affinity rule!");
            }
            this.matchMatcher = this.parseRule(this.affinityKey);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private ConditionMatcher parseRule(String rule) throws ParseException {
        ConditionMatcher matcher = this.getMatcher(rule);
        Set<String> values = matcher.getMatches();
        values.add(this.getUrl().getParameter(rule));
        return matcher;
    }

    @Override
    protected BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        if (!this.enabled) {
            if (needToPrintMessage) {
                messageHolder.set((Object)"Directly return. Reason: AffinityRouter disabled.");
            }
            return invokers;
        }
        if (CollectionUtils.isEmpty(invokers)) {
            if (needToPrintMessage) {
                messageHolder.set((Object)"Directly return. Reason: Invokers from previous router is empty.");
            }
            return invokers;
        }
        try {
            Object result = invokers.clone();
            result.removeIf(invoker -> !this.matchInvoker(invoker.getUrl(), url));
            if ((double)((BitList)result).size() / (double)invokers.size() >= this.ratio / 100.0) {
                if (needToPrintMessage) {
                    messageHolder.set((Object)"Match return.");
                }
                return result;
            }
            logger.warn("2-6", "execute affinity state router result is less than defined" + this.ratio, "", "The affinity result is ignored. consumer: " + NetUtils.getLocalHost() + ", service: " + url.getServiceKey() + ", router: " + url.getParameterAndDecoded("rule"));
            if (needToPrintMessage) {
                messageHolder.set((Object)"Directly return. Reason: Affinity state router result is less than defined.");
            }
            return invokers;
        }
        catch (Throwable t) {
            logger.error("2-7", "execute affinity state router exception", "", "Failed to execute affinity router rule: " + this.getUrl() + ", invokers: " + invokers + ", cause: " + t.getMessage(), t);
            if (needToPrintMessage) {
                messageHolder.set((Object)"Directly return. Reason: Error occurred ( or result is empty ).");
            }
            return invokers;
        }
    }

    @Override
    public boolean isRuntime() {
        return this.getUrl().getParameter("runtime", false);
    }

    private ConditionMatcher getMatcher(String key) {
        return ((ConditionMatcherFactory)this.moduleModel.getExtensionLoader(ConditionMatcherFactory.class).getExtension("param")).createMatcher(key, this.moduleModel);
    }

    private boolean matchInvoker(URL url, URL param) {
        return this.doMatch(url, param, null, this.matchMatcher);
    }

    private boolean doMatch(URL url, URL param, Invocation invocation, ConditionMatcher matcher) {
        Map sample = url.toOriginalMap();
        return matcher.isMatch(sample, param, invocation, false);
    }
}

