/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.router.RouterResult;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshRuleManager;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.VsDestinationGroup;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.DestinationRule;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.DestinationRuleSpec;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.Subset;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.DubboMatchRequest;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.DubboRoute;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.DubboRouteDetail;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.VirtualServiceRule;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.VirtualServiceSpec;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.destination.DubboDestination;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.destination.DubboRouteDestination;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.StringMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.util.VsDestinationGroupRuleListener;

public class MeshRuleRouter
implements Router,
VsDestinationGroupRuleListener {
    private int priority = -500;
    private boolean force = false;
    private URL url;
    private volatile VsDestinationGroup vsDestinationGroup;
    private Map<String, String> sourcesLabels = new HashMap<String, String>();
    private volatile List<Invoker<?>> invokerList = new ArrayList();
    private volatile Map<String, List<Invoker<?>>> subsetMap;
    private volatile String remoteAppName;
    private static final String INVALID_APP_NAME = "unknown";

    public MeshRuleRouter(URL url) {
        this.url = url;
        this.sourcesLabels.putAll(url.getParameters());
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public <T> RouterResult<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage) throws RpcException {
        List<DubboRouteDestination> routeDestination = this.getDubboRouteDestination(invocation);
        if (routeDestination == null) {
            return new RouterResult<Invoker<T>>(invokers);
        }
        DubboRouteDestination dubboRouteDestination = routeDestination.get(ThreadLocalRandom.current().nextInt(routeDestination.size()));
        DubboDestination dubboDestination = dubboRouteDestination.getDestination();
        String subset = dubboDestination.getSubset();
        Map<String, List<Invoker<?>>> subsetMapCopy = this.subsetMap;
        if (subsetMapCopy != null) {
            while (true) {
                List<Invoker<?>> result;
                if (CollectionUtils.isNotEmpty(result = subsetMapCopy.get(subset))) {
                    return new RouterResult<Invoker<T>>(result);
                }
                dubboRouteDestination = dubboDestination.getFallback();
                if (dubboRouteDestination == null) break;
                dubboDestination = dubboRouteDestination.getDestination();
                subset = dubboDestination.getSubset();
            }
            return new RouterResult<Invoker<T>>(null);
        }
        return new RouterResult<Invoker<T>>(invokers);
    }

    @Override
    public <T> void notify(List<Invoker<T>> invokers) {
        List<Invoker<?>> invokerList = invokers == null ? Collections.emptyList() : invokers;
        this.invokerList = invokerList;
        this.registerAppRule(invokerList);
        this.computeSubset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAppRule(List<Invoker<?>> invokers) {
        if (StringUtils.isEmpty((String)this.remoteAppName)) {
            MeshRuleRouter meshRuleRouter = this;
            synchronized (meshRuleRouter) {
                if (StringUtils.isEmpty((String)this.remoteAppName) && CollectionUtils.isNotEmpty(invokers)) {
                    for (Invoker<?> invoker : invokers) {
                        String applicationName = invoker.getUrl().getRemoteApplication();
                        if (!StringUtils.isNotEmpty((String)applicationName) || INVALID_APP_NAME.equals(applicationName)) continue;
                        this.remoteAppName = applicationName;
                        MeshRuleManager.register(this.remoteAppName, this);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void onRuleChange(VsDestinationGroup vsDestinationGroup) {
        this.vsDestinationGroup = vsDestinationGroup;
        this.computeSubset();
    }

    @Override
    public boolean isRuntime() {
        return true;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    private List<DubboRouteDestination> getDubboRouteDestination(Invocation invocation) {
        List<VirtualServiceRule> virtualServiceRuleList;
        if (this.vsDestinationGroup != null && (virtualServiceRuleList = this.vsDestinationGroup.getVirtualServiceRuleList()).size() > 0) {
            for (VirtualServiceRule virtualServiceRule : virtualServiceRuleList) {
                DubboRoute dubboRoute = this.getDubboRoute(virtualServiceRule, invocation);
                if (dubboRoute == null) continue;
                return this.getDubboRouteDestination(dubboRoute, invocation);
            }
        }
        return null;
    }

    protected DubboRoute getDubboRoute(VirtualServiceRule virtualServiceRule, Invocation invocation) {
        String serviceName = invocation.getServiceName();
        VirtualServiceSpec spec = virtualServiceRule.getSpec();
        List<DubboRoute> dubboRouteList = spec.getDubbo();
        if (dubboRouteList.size() > 0) {
            for (DubboRoute dubboRoute : dubboRouteList) {
                List<StringMatch> stringMatchList = dubboRoute.getServices();
                if (CollectionUtils.isEmpty(stringMatchList)) {
                    return dubboRoute;
                }
                for (StringMatch stringMatch : stringMatchList) {
                    if (!StringMatch.isMatch(stringMatch, serviceName)) continue;
                    return dubboRoute;
                }
            }
        }
        return null;
    }

    protected List<DubboRouteDestination> getDubboRouteDestination(DubboRoute dubboRoute, Invocation invocation) {
        DubboRouteDetail dubboRouteDetail;
        List<DubboRouteDetail> dubboRouteDetailList = dubboRoute.getRoutedetail();
        if (dubboRouteDetailList.size() > 0 && (dubboRouteDetail = this.findMatchDubboRouteDetail(dubboRouteDetailList, invocation)) != null) {
            return dubboRouteDetail.getRoute();
        }
        return null;
    }

    protected DubboRouteDetail findMatchDubboRouteDetail(List<DubboRouteDetail> dubboRouteDetailList, Invocation invocation) {
        String methodName = invocation.getMethodName();
        String[] parameterTypeList = invocation.getCompatibleParamSignatures();
        Object[] parameters = invocation.getArguments();
        for (DubboRouteDetail dubboRouteDetail : dubboRouteDetailList) {
            List<DubboMatchRequest> matchRequestList = dubboRouteDetail.getMatch();
            if (CollectionUtils.isEmpty(matchRequestList)) {
                return dubboRouteDetail;
            }
            boolean match = true;
            for (DubboMatchRequest dubboMatchRequest : matchRequestList) {
                if (DubboMatchRequest.isMatch(dubboMatchRequest, methodName, parameterTypeList, parameters, this.sourcesLabels, new HashMap<String, String>(), invocation.getAttachments(), new HashMap<String, String>())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return dubboRouteDetail;
        }
        return null;
    }

    protected synchronized void computeSubset() {
        if (CollectionUtils.isEmpty(this.invokerList)) {
            this.subsetMap = null;
            return;
        }
        if (this.vsDestinationGroup == null) {
            this.subsetMap = null;
            return;
        }
        Map<String, List<Invoker<?>>> subsetMap = this.computeSubsetMap(this.invokerList, this.vsDestinationGroup.getDestinationRuleList());
        this.subsetMap = subsetMap.size() == 0 ? null : subsetMap;
    }

    protected Map<String, List<Invoker<?>>> computeSubsetMap(List<Invoker<?>> invokers, List<DestinationRule> destinationRules) {
        HashMap subsetMap = new HashMap();
        for (DestinationRule destinationRule : destinationRules) {
            DestinationRuleSpec destinationRuleSpec = destinationRule.getSpec();
            List<Subset> subsetList = destinationRuleSpec.getSubsets();
            for (Subset subset : subsetList) {
                String subsetName = subset.getName();
                ArrayList subsetInvokerList = new ArrayList();
                subsetMap.put(subsetName, subsetInvokerList);
                Map<String, String> labels = subset.getLabels();
                for (Invoker<?> invoker : invokers) {
                    Map parameters = invoker.getUrl().getServiceParameters(this.url.getProtocolServiceKey());
                    if (!this.containMapKeyValue(parameters, labels)) continue;
                    subsetInvokerList.add(invoker);
                }
            }
        }
        return subsetMap;
    }

    protected boolean containMapKeyValue(Map<String, String> originMap, Map<String, String> inputMap) {
        if (inputMap == null || inputMap.size() == 0) {
            return true;
        }
        for (Map.Entry<String, String> entry : inputMap.entrySet()) {
            String originMapValue;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.equals(originMapValue = originMap.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
        MeshRuleManager.unregister(this);
    }

    protected void setVsDestinationGroup(VsDestinationGroup vsDestinationGroup) {
        this.vsDestinationGroup = vsDestinationGroup;
    }

    protected void setSourcesLabels(Map<String, String> sourcesLabels) {
        this.sourcesLabels = sourcesLabels;
    }

    protected void setInvokerList(List<Invoker<?>> invokerList) {
        this.invokerList = invokerList;
    }

    protected void setSubsetMap(Map<String, List<Invoker<?>>> subsetMap) {
        this.subsetMap = subsetMap;
    }

    public VsDestinationGroup getVsDestinationGroup() {
        return this.vsDestinationGroup;
    }

    public Map<String, String> getSourcesLabels() {
        return this.sourcesLabels;
    }

    public List<Invoker<?>> getInvokerList() {
        return this.invokerList;
    }

    public Map<String, List<Invoker<?>>> getSubsetMap() {
        return this.subsetMap;
    }
}

