/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.router.state.AddrCache;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.RouterCache;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterFactory;

public class RouterChain<T> {
    private static final Logger logger = LoggerFactory.getLogger(RouterChain.class);
    private volatile List<Invoker<T>> invokers = Collections.emptyList();
    private volatile List<Router> routers = Collections.emptyList();
    private List<Router> builtinRouters = Collections.emptyList();
    private List<StateRouter> builtinStateRouters = Collections.emptyList();
    private List<StateRouter> stateRouters = Collections.emptyList();
    private final ExecutorRepository executorRepository;
    protected URL url;
    private AtomicReference<AddrCache<T>> cache = new AtomicReference();
    private final Semaphore loopPermit = new Semaphore(1);
    private final Semaphore loopPermitNotify = new Semaphore(1);
    private final ExecutorService loopPool;
    private AtomicBoolean firstBuildCache = new AtomicBoolean(true);

    public static <T> RouterChain<T> buildChain(URL url) {
        return new RouterChain<T>(url);
    }

    private RouterChain(URL url) {
        this.executorRepository = (ExecutorRepository)url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        this.loopPool = this.executorRepository.nextExecutorExecutor();
        List extensionFactories = url.getOrDefaultApplicationModel().getExtensionLoader(RouterFactory.class).getActivateExtension(url, "router");
        List<Router> routers = extensionFactories.stream().map(factory -> factory.getRouter(url)).sorted(Router::compareTo).collect(Collectors.toList());
        this.initWithRouters(routers);
        List extensionStateRouterFactories = url.getOrDefaultApplicationModel().getExtensionLoader(StateRouterFactory.class).getActivateExtension(url, "stateRouter");
        List<StateRouter> stateRouters = extensionStateRouterFactories.stream().map(factory -> factory.getRouter(url, this)).sorted(StateRouter::compareTo).collect(Collectors.toList());
        this.initWithStateRouters(stateRouters);
    }

    public void initWithRouters(List<Router> builtinRouters) {
        this.builtinRouters = builtinRouters;
        this.routers = new ArrayList<Router>(builtinRouters);
    }

    private void initWithStateRouters(List<StateRouter> builtinRouters) {
        this.builtinStateRouters = builtinRouters;
        this.stateRouters = new ArrayList<StateRouter>(builtinRouters);
    }

    public void addRouters(List<Router> routers) {
        ArrayList<Router> newRouters = new ArrayList<Router>();
        newRouters.addAll(this.builtinRouters);
        newRouters.addAll(routers);
        CollectionUtils.sort(newRouters);
        this.routers = newRouters;
    }

    public void addStateRouters(List<StateRouter> stateRouters) {
        ArrayList<StateRouter> newStateRouters = new ArrayList<StateRouter>();
        newStateRouters.addAll(this.builtinStateRouters);
        newStateRouters.addAll(stateRouters);
        CollectionUtils.sort(newStateRouters);
        this.stateRouters = newStateRouters;
    }

    public List<Router> getRouters() {
        return this.routers;
    }

    public List<StateRouter> getStateRouters() {
        return this.stateRouters;
    }

    public List<Invoker<T>> route(URL url, Invocation invocation) {
        AddrCache<T> cache = this.cache.get();
        if (cache == null) {
            throw new RpcException(10, "Failed to invoke the method " + invocation.getMethodName() + " in the service " + url.getServiceInterface() + ". address cache not build  on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ".");
        }
        BitList<Invoker<T>> finalBitListInvokers = new BitList<Invoker<T>>(this.invokers, false);
        for (StateRouter stateRouter : this.stateRouters) {
            if (!stateRouter.isEnable()) continue;
            RouterCache<T> routerCache = cache.getCache().get(stateRouter.getName());
            finalBitListInvokers = stateRouter.route(finalBitListInvokers, routerCache, url, invocation);
        }
        List<Invoker<T>> finalInvokers = new ArrayList<Invoker<T>>(finalBitListInvokers.size());
        for (Invoker<T> invoker : finalBitListInvokers) {
            finalInvokers.add(invoker);
        }
        for (Router router : this.routers) {
            finalInvokers = router.route(finalInvokers, url, invocation);
        }
        return finalInvokers;
    }

    public void setInvokers(List<Invoker<T>> invokers) {
        this.invokers = invokers == null ? Collections.emptyList() : invokers;
        this.stateRouters.forEach(router -> router.notify(this.invokers));
        this.routers.forEach(router -> router.notify(this.invokers));
        this.loop(true);
    }

    private void buildCache(boolean notify) {
        if (CollectionUtils.isEmpty(this.invokers)) {
            return;
        }
        AddrCache<T> origin = this.cache.get();
        ArrayList<Invoker<T>> copyInvokers = new ArrayList<Invoker<T>>(this.invokers);
        AddrCache newCache = new AddrCache();
        HashMap routerCacheMap = new HashMap((int)((float)this.stateRouters.size() / 0.75f) + 1);
        newCache.setInvokers(this.invokers);
        for (StateRouter stateRouter : this.stateRouters) {
            try {
                RouterCache routerCache = this.poolRouter(stateRouter, origin, copyInvokers, notify);
                routerCacheMap.put(stateRouter.getName(), routerCache);
            }
            catch (Throwable t) {
                logger.error("Failed to pool router: " + stateRouter.getUrl() + ", cause: " + t.getMessage(), t);
                return;
            }
        }
        newCache.setCache(routerCacheMap);
        this.cache.set(newCache);
    }

    private RouterCache poolRouter(StateRouter router, AddrCache<T> origin, List<Invoker<T>> invokers, boolean notify) {
        String routerName = router.getName();
        if (this.isCacheMiss(origin, routerName) || router.shouldRePool() || notify) {
            return router.pool(invokers);
        }
        RouterCache<T> routerCache = origin.getCache().get(routerName);
        if (routerCache == null) {
            return new RouterCache();
        }
        return routerCache;
    }

    private boolean isCacheMiss(AddrCache<T> cache, String routerName) {
        return cache == null || cache.getCache() == null || cache.getInvokers() == null || cache.getCache().get(routerName) == null;
    }

    public void loop(boolean notify) {
        if (this.firstBuildCache.compareAndSet(true, false)) {
            this.buildCache(notify);
        }
        if (notify) {
            if (this.loopPermitNotify.tryAcquire()) {
                this.loopPool.submit(new NotifyLoopRunnable(true, this.loopPermitNotify));
            }
        } else if (this.loopPermit.tryAcquire()) {
            this.loopPool.submit(new NotifyLoopRunnable(false, this.loopPermit));
        }
    }

    public void destroy() {
        this.invokers = Collections.emptyList();
        for (Router router : this.routers) {
            try {
                router.stop();
            }
            catch (Exception e) {
                logger.error("Error trying to stop router " + router.getClass(), (Throwable)e);
            }
        }
        this.routers = Collections.emptyList();
        this.builtinRouters = Collections.emptyList();
        for (StateRouter stateRouter : this.stateRouters) {
            try {
                stateRouter.stop();
            }
            catch (Exception e) {
                logger.error("Error trying to stop stateRouter " + stateRouter.getClass(), (Throwable)e);
            }
        }
        this.stateRouters = Collections.emptyList();
        this.builtinStateRouters = Collections.emptyList();
    }

    class NotifyLoopRunnable
    implements Runnable {
        private final boolean notify;
        private final Semaphore loopPermit;

        public NotifyLoopRunnable(boolean notify, Semaphore loopPermit) {
            this.notify = notify;
            this.loopPermit = loopPermit;
        }

        @Override
        public void run() {
            RouterChain.this.buildCache(this.notify);
            this.loopPermit.release();
        }
    }
}

