/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;

@SPI(value="default")
public interface FilterChainBuilder {
    public <T> Invoker<T> buildInvokerChain(Invoker<T> var1, String var2, String var3);

    public <T> ClusterInvoker<T> buildClusterInvokerChain(ClusterInvoker<T> var1, String var2, String var3);

    public static class ClusterFilterChainNode<T, TYPE extends ClusterInvoker<T>, FILTER extends BaseFilter>
    extends FilterChainNode<T, TYPE, FILTER>
    implements ClusterInvoker<T> {
        public ClusterFilterChainNode(TYPE originalInvoker, Invoker<T> nextNode, FILTER filter) {
            super(originalInvoker, nextNode, filter);
        }

        @Override
        public URL getRegistryUrl() {
            return ((ClusterInvoker)this.getOriginalInvoker()).getRegistryUrl();
        }

        @Override
        public Directory<T> getDirectory() {
            return ((ClusterInvoker)this.getOriginalInvoker()).getDirectory();
        }

        @Override
        public boolean isDestroyed() {
            return ((ClusterInvoker)this.getOriginalInvoker()).isDestroyed();
        }
    }

    public static class FilterChainNode<T, TYPE extends Invoker<T>, FILTER extends BaseFilter>
    implements Invoker<T> {
        TYPE originalInvoker;
        Invoker<T> nextNode;
        FILTER filter;

        public FilterChainNode(TYPE originalInvoker, Invoker<T> nextNode, FILTER filter) {
            this.originalInvoker = originalInvoker;
            this.nextNode = nextNode;
            this.filter = filter;
        }

        public TYPE getOriginalInvoker() {
            return this.originalInvoker;
        }

        public Class<T> getInterface() {
            return this.originalInvoker.getInterface();
        }

        public URL getUrl() {
            return this.originalInvoker.getUrl();
        }

        public boolean isAvailable() {
            return this.originalInvoker.isAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Result invoke(Invocation invocation) throws RpcException {
            try {
                Result asyncResult = this.filter.invoke(this.nextNode, invocation);
                return asyncResult.whenCompleteWithContext((r, t) -> {
                    if (this.filter instanceof ListenableFilter) {
                        ListenableFilter listenableFilter = (ListenableFilter)this.filter;
                        BaseFilter.Listener listener = listenableFilter.listener(invocation);
                        try {
                            if (listener == null) return;
                            if (t == null) {
                                listener.onResponse(r, this.originalInvoker, invocation);
                                return;
                            }
                            listener.onError(t, this.originalInvoker, invocation);
                            return;
                        }
                        finally {
                            listenableFilter.removeListener(invocation);
                        }
                    } else {
                        if (!(this.filter instanceof BaseFilter.Listener)) return;
                        BaseFilter.Listener listener = (BaseFilter.Listener)this.filter;
                        if (t == null) {
                            listener.onResponse(r, this.originalInvoker, invocation);
                            return;
                        } else {
                            listener.onError(t, this.originalInvoker, invocation);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (this.filter instanceof ListenableFilter) {
                    ListenableFilter listenableFilter = (ListenableFilter)this.filter;
                    try {
                        BaseFilter.Listener listener = listenableFilter.listener(invocation);
                        if (listener == null) throw e;
                        listener.onError((Throwable)e, this.originalInvoker, invocation);
                        throw e;
                    }
                    finally {
                        listenableFilter.removeListener(invocation);
                    }
                } else {
                    if (!(this.filter instanceof BaseFilter.Listener)) throw e;
                    BaseFilter.Listener listener = (BaseFilter.Listener)this.filter;
                    listener.onError((Throwable)e, this.originalInvoker, invocation);
                }
                throw e;
            }
        }

        public void destroy() {
            this.originalInvoker.destroy();
        }

        public String toString() {
            return this.originalInvoker.toString();
        }
    }
}

