/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.tag.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.cluster.router.AbstractRouterRule;
import org.apache.dubbo.rpc.cluster.router.tag.model.Tag;

public class TagRouterRule
extends AbstractRouterRule {
    private List<Tag> tags;
    private Map<String, List<String>> addressToTagnames = new HashMap<String, List<String>>();
    private Map<String, List<String>> tagnameToAddresses = new HashMap<String, List<String>>();

    public static TagRouterRule parseFromMap(Map<String, Object> map) {
        TagRouterRule tagRouterRule = new TagRouterRule();
        tagRouterRule.parseFromMap0(map);
        Object tags = map.get("tags");
        if (tags != null && List.class.isAssignableFrom(tags.getClass())) {
            tagRouterRule.setTags(((List)tags).stream().map(Tag::parseFromMap).collect(Collectors.toList()));
        }
        return tagRouterRule;
    }

    public void init() {
        if (!this.isValid()) {
            return;
        }
        this.tags.stream().filter(tag -> CollectionUtils.isNotEmpty(tag.getAddresses())).forEach(tag -> {
            this.tagnameToAddresses.put(tag.getName(), tag.getAddresses());
            tag.getAddresses().forEach(addr -> {
                List tagNames = this.addressToTagnames.computeIfAbsent((String)addr, k -> new ArrayList());
                tagNames.add(tag.getName());
            });
        });
    }

    public List<String> getAddresses() {
        return this.tags.stream().filter(tag -> CollectionUtils.isNotEmpty(tag.getAddresses())).flatMap(tag -> tag.getAddresses().stream()).collect(Collectors.toList());
    }

    public List<String> getTagNames() {
        return this.tags.stream().map(Tag::getName).collect(Collectors.toList());
    }

    public Map<String, List<String>> getAddressToTagnames() {
        return this.addressToTagnames;
    }

    public Map<String, List<String>> getTagnameToAddresses() {
        return this.tagnameToAddresses;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }
}

