/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.wrapper;

import java.util.Collection;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.filter.FilterChainBuilder;
import org.apache.dubbo.rpc.cluster.filter.InvocationInterceptorBuilder;
import org.apache.dubbo.rpc.cluster.interceptor.ClusterInterceptor;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public abstract class AbstractCluster
implements Cluster {
    private <T> Invoker<T> buildClusterInterceptors(AbstractClusterInvoker<T> clusterInvoker, String key) {
        AbstractClusterInvoker<T> last = this.buildInterceptorInvoker(new ClusterFilterInvoker<T>(clusterInvoker));
        if (Boolean.parseBoolean(ConfigurationUtils.getProperty((String)"dubbo.application.cluster.interceptor.compatible", (String)"false"))) {
            return this.build27xCompatibleClusterInterceptors(clusterInvoker, last);
        }
        return last;
    }

    @Override
    public <T> Invoker<T> join(Directory<T> directory) throws RpcException {
        if (directory instanceof StaticDirectory) {
            return this.doJoin(directory);
        }
        return this.buildClusterInterceptors(this.doJoin(directory), directory.getUrl().getParameter("reference.interceptor"));
    }

    private <T> AbstractClusterInvoker<T> buildInterceptorInvoker(AbstractClusterInvoker<T> invoker) {
        List builders = ExtensionLoader.getExtensionLoader(InvocationInterceptorBuilder.class).getActivateExtensions();
        if (CollectionUtils.isEmpty((Collection)builders)) {
            return invoker;
        }
        return new InvocationInterceptorInvoker<T>(invoker, builders);
    }

    protected abstract <T> AbstractClusterInvoker<T> doJoin(Directory<T> var1) throws RpcException;

    @Deprecated
    private <T> ClusterInvoker<T> build27xCompatibleClusterInterceptors(AbstractClusterInvoker<T> clusterInvoker, AbstractClusterInvoker<T> last) {
        List interceptors = ExtensionLoader.getExtensionLoader(ClusterInterceptor.class).getActivateExtensions();
        if (!interceptors.isEmpty()) {
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                ClusterInterceptor interceptor = (ClusterInterceptor)interceptors.get(i);
                AbstractClusterInvoker<T> next = last;
                last = new InterceptorInvokerNode<T>(clusterInvoker, interceptor, next);
            }
        }
        return last;
    }

    @Deprecated
    static class InterceptorInvokerNode<T>
    extends AbstractClusterInvoker<T> {
        private AbstractClusterInvoker<T> clusterInvoker;
        private ClusterInterceptor interceptor;
        private AbstractClusterInvoker<T> next;

        public InterceptorInvokerNode(AbstractClusterInvoker<T> clusterInvoker, ClusterInterceptor interceptor, AbstractClusterInvoker<T> next) {
            this.clusterInvoker = clusterInvoker;
            this.interceptor = interceptor;
            this.next = next;
        }

        @Override
        public Class<T> getInterface() {
            return this.clusterInvoker.getInterface();
        }

        @Override
        public URL getUrl() {
            return this.clusterInvoker.getUrl();
        }

        @Override
        public boolean isAvailable() {
            return this.clusterInvoker.isAvailable();
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            Result asyncResult;
            try {
                this.interceptor.before(this.next, invocation);
                asyncResult = this.interceptor.intercept(this.next, invocation);
            }
            catch (Exception e) {
                if (this.interceptor instanceof ClusterInterceptor.Listener) {
                    ClusterInterceptor.Listener listener = (ClusterInterceptor.Listener)((Object)this.interceptor);
                    listener.onError(e, this.clusterInvoker, invocation);
                }
                throw e;
            }
            finally {
                this.interceptor.after(this.next, invocation);
            }
            return asyncResult.whenCompleteWithContext((r, t) -> {
                if (this.interceptor instanceof ClusterInterceptor.Listener) {
                    ClusterInterceptor.Listener listener = (ClusterInterceptor.Listener)((Object)this.interceptor);
                    if (t == null) {
                        listener.onMessage((Result)r, this.clusterInvoker, invocation);
                    } else {
                        listener.onError((Throwable)t, this.clusterInvoker, invocation);
                    }
                }
            });
        }

        @Override
        public void destroy() {
            this.clusterInvoker.destroy();
        }

        @Override
        public String toString() {
            return this.clusterInvoker.toString();
        }

        @Override
        protected Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
            return null;
        }
    }

    static class InvocationInterceptorInvoker<T>
    extends AbstractClusterInvoker<T> {
        private ClusterInvoker<T> interceptorInvoker;

        public InvocationInterceptorInvoker(AbstractClusterInvoker<T> invoker, List<InvocationInterceptorBuilder> builders) {
            ClusterInvoker<T> tmpInvoker = invoker;
            for (InvocationInterceptorBuilder builder : builders) {
                tmpInvoker = builder.buildClusterInterceptorChain(tmpInvoker, "invocation.interceptor", "consumer");
            }
            this.interceptorInvoker = tmpInvoker;
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            return this.interceptorInvoker.invoke(invocation);
        }

        @Override
        public Directory<T> getDirectory() {
            return this.interceptorInvoker.getDirectory();
        }

        @Override
        public URL getRegistryUrl() {
            return this.interceptorInvoker.getRegistryUrl();
        }

        @Override
        public boolean isDestroyed() {
            return this.interceptorInvoker.isDestroyed();
        }

        @Override
        public URL getUrl() {
            return this.interceptorInvoker.getUrl();
        }

        @Override
        protected Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
            return null;
        }
    }

    static class ClusterFilterInvoker<T>
    extends AbstractClusterInvoker<T> {
        private ClusterInvoker<T> filterInvoker;

        public ClusterFilterInvoker(AbstractClusterInvoker<T> invoker) {
            List builders = ExtensionLoader.getExtensionLoader(FilterChainBuilder.class).getActivateExtensions();
            if (CollectionUtils.isEmpty((Collection)builders)) {
                this.filterInvoker = invoker;
            } else {
                ClusterInvoker<T> tmpInvoker = invoker;
                for (FilterChainBuilder builder : builders) {
                    tmpInvoker = builder.buildClusterInvokerChain(tmpInvoker, "reference.filter", "consumer");
                }
                this.filterInvoker = tmpInvoker;
            }
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            return this.filterInvoker.invoke(invocation);
        }

        @Override
        public Directory<T> getDirectory() {
            return this.filterInvoker.getDirectory();
        }

        @Override
        public URL getRegistryUrl() {
            return this.filterInvoker.getRegistryUrl();
        }

        @Override
        public boolean isDestroyed() {
            return this.filterInvoker.isDestroyed();
        }

        @Override
        public URL getUrl() {
            return this.filterInvoker.getUrl();
        }

        @Override
        protected Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
            return null;
        }
    }
}

