/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshAppRuleListener;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshRuleRouter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public final class MeshRuleManager {
    public static final Logger logger = LoggerFactory.getLogger(MeshRuleManager.class);
    private static final String MESH_RULE_DATA_ID_SUFFIX = ".MESHAPPRULE";
    private static final String GROUP = "DEFAULT_GROUP";
    private static ConcurrentHashMap<String, MeshAppRuleListener> appRuleListeners = new ConcurrentHashMap();

    public static synchronized void subscribeAppRule(String app) {
        MeshAppRuleListener meshAppRuleListener = new MeshAppRuleListener(app);
        String appRuleDataId = app + MESH_RULE_DATA_ID_SUFFIX;
        DynamicConfiguration configuration = ApplicationModel.getEnvironment().getDynamicConfiguration().orElse(null);
        if (configuration == null) {
            logger.warn("Doesn't support DynamicConfiguration!");
            return;
        }
        try {
            String rawConfig = configuration.getConfig(appRuleDataId, GROUP, 5000L);
            if (rawConfig != null) {
                meshAppRuleListener.receiveConfigInfo(rawConfig);
            }
        }
        catch (Throwable throwable) {
            logger.error("get MeshRuleManager app rule failed.", throwable);
        }
        configuration.addListener(appRuleDataId, GROUP, (ConfigurationListener)meshAppRuleListener);
        appRuleListeners.put(app, meshAppRuleListener);
    }

    public static void register(String app, MeshRuleRouter subscriber) {
        MeshAppRuleListener meshAppRuleListener = appRuleListeners.get(app);
        if (meshAppRuleListener == null) {
            logger.warn("appRuleListener can't find when Router register");
            return;
        }
        meshAppRuleListener.register(subscriber);
    }

    public static void unregister(MeshRuleRouter subscriber) {
        Collection<MeshAppRuleListener> listeners = appRuleListeners.values();
        for (MeshAppRuleListener listener : listeners) {
            listener.unregister(subscriber);
        }
    }
}

