/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshRuleRouter;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.VsDestinationGroup;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.DestinationRule;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.VirtualServiceRule;
import org.apache.dubbo.rpc.cluster.router.mesh.util.VsDestinationGroupRuleDispatcher;
import org.yaml.snakeyaml.Yaml;

public class MeshAppRuleListener
implements ConfigurationListener {
    public static final Logger logger = LoggerFactory.getLogger(MeshAppRuleListener.class);
    private final VsDestinationGroupRuleDispatcher vsDestinationGroupRuleDispatcher = new VsDestinationGroupRuleDispatcher();
    private String appName;
    private VsDestinationGroup vsDestinationGroupHolder;

    public MeshAppRuleListener(String appName) {
        this.appName = appName;
    }

    public void receiveConfigInfo(String configInfo) {
        logger.info(MessageFormat.format("[MeshAppRule] Received rule for app [{0}]: {1}.", this.appName, configInfo));
        try {
            VsDestinationGroup vsDestinationGroup = new VsDestinationGroup();
            vsDestinationGroup.setAppName(this.appName);
            Yaml yaml = new Yaml();
            Yaml yaml2 = new Yaml();
            Iterable objectIterable = yaml.loadAll(configInfo);
            for (Object result : objectIterable) {
                Map resultMap = (Map)result;
                if (resultMap.get("kind").equals("DestinationRule")) {
                    DestinationRule destinationRule = (DestinationRule)yaml2.loadAs(yaml2.dump(result), DestinationRule.class);
                    vsDestinationGroup.getDestinationRuleList().add(destinationRule);
                    continue;
                }
                if (!resultMap.get("kind").equals("VirtualService")) continue;
                VirtualServiceRule virtualServiceRule = (VirtualServiceRule)yaml2.loadAs(yaml2.dump(result), VirtualServiceRule.class);
                vsDestinationGroup.getVirtualServiceRuleList().add(virtualServiceRule);
            }
            this.vsDestinationGroupHolder = vsDestinationGroup;
        }
        catch (Exception e) {
            logger.error("[MeshAppRule] parse failed: " + configInfo, (Throwable)e);
        }
        if (this.vsDestinationGroupHolder != null) {
            this.vsDestinationGroupRuleDispatcher.post(this.vsDestinationGroupHolder);
        }
    }

    public void register(MeshRuleRouter subscriber) {
        if (this.vsDestinationGroupHolder != null) {
            subscriber.onRuleChange(this.vsDestinationGroupHolder);
        }
        this.vsDestinationGroupRuleDispatcher.register(subscriber);
    }

    public void unregister(MeshRuleRouter sub) {
        this.vsDestinationGroupRuleDispatcher.unregister(sub);
    }

    public void process(ConfigChangedEvent event) {
        this.receiveConfigInfo(event.getContent());
    }
}

