/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter.support;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.ZoneDetector;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;

@Activate(group={"consumer"}, value={"cluster:zone-aware"})
public class ZoneAwareFilter
implements ClusterFilter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContext rpcContext = RpcContext.getContext();
        String zone = rpcContext.getAttachment("registry_zone");
        String force = rpcContext.getAttachment("registry_zone_force");
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(ZoneDetector.class);
        if (StringUtils.isEmpty((String)zone) && loader.hasExtension("default")) {
            ZoneDetector detector = (ZoneDetector)loader.getExtension("default");
            zone = detector.getZoneOfCurrentRequest(invocation);
            force = detector.isZoneForcingEnabled(invocation, zone);
        }
        if (StringUtils.isNotEmpty((String)zone)) {
            invocation.setAttachment("registry_zone", zone);
        }
        if (StringUtils.isNotEmpty((String)force)) {
            invocation.setAttachment("registry_zone_force", force);
        }
        return invoker.invoke(invocation);
    }
}

