/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter.support;

import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;

@Activate(group={"consumer"}, order=-10000)
public class ConsumerContextFilter
implements ClusterFilter,
BaseFilter.Listener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TimeoutCountDown timeoutCountDown;
        Object countDown;
        Map contextAttachments;
        RpcContext context = RpcContext.getContext();
        context.setInvocation(invocation).setLocalAddress(NetUtils.getLocalHost(), 0).setAttachment("remote.application", invoker.getUrl().getApplication());
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(invoker);
        }
        if (CollectionUtils.isNotEmptyMap((Map)(contextAttachments = RpcContext.getContext().getObjectAttachments()))) {
            ((RpcInvocation)invocation).addObjectAttachments(contextAttachments);
        }
        if ((countDown = context.get("timeout-countdown")) != null && (timeoutCountDown = (TimeoutCountDown)countDown).isExpired()) {
            return AsyncRpcResult.newDefaultAsyncResult((Throwable)new RpcException(8, "No time left for making the following call: " + invocation.getServiceName() + "." + invocation.getMethodName() + ", terminate directly."), (Invocation)invocation);
        }
        try {
            RpcContext.removeServerContext();
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            RpcContext.removeContext();
        }
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        RpcContext.getServerContext().setObjectAttachments(appResponse.getObjectAttachments());
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

