/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.directory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterChain;

public abstract class AbstractDirectory<T>
implements Directory<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDirectory.class);
    private final URL url;
    private volatile boolean destroyed = false;
    protected volatile URL consumerUrl;
    protected RouterChain<T> routerChain;
    protected final Map<String, String> queryMap;

    public AbstractDirectory(URL url) {
        this(url, null, false);
    }

    public AbstractDirectory(URL url, boolean isUrlFromRegistry) {
        this(url, null, isUrlFromRegistry);
    }

    public AbstractDirectory(URL url, RouterChain<T> routerChain, boolean isUrlFromRegistry) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url.removeAttribute("refer").removeParameter("monitor");
        Object referParams = url.getAttribute("refer");
        if (referParams != null) {
            this.queryMap = (Map)referParams;
            this.consumerUrl = (URL)url.getAttribute("CONSUMER_URL");
        } else {
            this.queryMap = StringUtils.parseQueryString((String)url.getParameterAndDecoded("refer"));
        }
        if (this.consumerUrl == null) {
            String host = StringUtils.isNotEmpty((String)this.queryMap.get("register.ip")) ? this.queryMap.get("register.ip") : this.url.getHost();
            String path = this.queryMap.get("path");
            String consumedProtocol = this.queryMap.get("protocol") == null ? "dubbo" : this.queryMap.get("protocol");
            URL consumerUrlFrom = this.url.setHost(host).setPort(0).setProtocol(consumedProtocol).setPath(path == null ? this.queryMap.get("interface") : path);
            if (isUrlFromRegistry) {
                consumerUrlFrom = consumerUrlFrom.clearParameters();
            }
            this.consumerUrl = consumerUrlFrom.addParameters(this.queryMap).removeParameter("monitor");
        }
        this.setRouterChain(routerChain);
    }

    @Override
    public List<Invoker<T>> list(Invocation invocation) throws RpcException {
        if (this.destroyed) {
            throw new RpcException("Directory already destroyed .url: " + this.getUrl());
        }
        return this.doList(invocation);
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public RouterChain<T> getRouterChain() {
        return this.routerChain;
    }

    public void setRouterChain(RouterChain<T> routerChain) {
        this.routerChain = routerChain;
    }

    protected void addRouters(List<Router> routers) {
        routers = routers == null ? Collections.emptyList() : routers;
        this.routerChain.addRouters(routers);
    }

    @Override
    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.destroyed = true;
    }

    @Override
    public void discordAddresses() {
    }

    protected abstract List<Invoker<T>> doList(Invocation var1) throws RpcException;
}

