/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.directory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterChain;

public abstract class AbstractDirectory<T>
implements Directory<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDirectory.class);
    private final URL url;
    private volatile boolean destroyed = false;
    protected volatile URL consumerUrl;
    protected final Map<String, String> queryMap;
    protected final String consumedProtocol;
    protected RouterChain<T> routerChain;

    public AbstractDirectory(URL url) {
        this(url, null);
    }

    public AbstractDirectory(URL url, RouterChain<T> routerChain) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.queryMap = StringUtils.parseQueryString((String)url.getParameterAndDecoded("refer"));
        String path = this.queryMap.get("path");
        this.consumedProtocol = this.queryMap.get("protocol") == null ? "dubbo" : this.queryMap.get("protocol");
        this.url = url.removeParameter("refer").removeParameter("monitor");
        this.consumerUrl = this.url.setProtocol(this.consumedProtocol).setPath(path == null ? this.queryMap.get("interface") : path).addParameters(this.queryMap).removeParameter("monitor");
        this.setRouterChain(routerChain);
    }

    @Override
    public List<Invoker<T>> list(Invocation invocation) throws RpcException {
        if (this.destroyed) {
            throw new RpcException("Directory already destroyed .url: " + this.getUrl());
        }
        return this.doList(invocation);
    }

    public URL getUrl() {
        return this.url;
    }

    public RouterChain<T> getRouterChain() {
        return this.routerChain;
    }

    public void setRouterChain(RouterChain<T> routerChain) {
        this.routerChain = routerChain;
    }

    protected void addRouters(List<Router> routers) {
        routers = routers == null ? Collections.emptyList() : routers;
        this.routerChain.addRouters(routers);
    }

    @Override
    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.destroyed = true;
    }

    protected abstract List<Invoker<T>> doList(Invocation var1) throws RpcException;
}

