/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.configurator;

import java.util.HashSet;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.cluster.Configurator;

public abstract class AbstractConfigurator
implements Configurator {
    private static final String TILDE = "~";
    private final URL configuratorUrl;

    public AbstractConfigurator(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("configurator url == null");
        }
        this.configuratorUrl = url;
    }

    @Override
    public URL getUrl() {
        return this.configuratorUrl;
    }

    @Override
    public URL configure(URL url) {
        if (!this.configuratorUrl.getParameter("enabled", true) || this.configuratorUrl.getHost() == null || url == null || url.getHost() == null) {
            return url;
        }
        String apiVersion = this.configuratorUrl.getParameter("configVersion");
        if (StringUtils.isNotEmpty((String)apiVersion)) {
            String configuratorSide;
            String currentSide = url.getParameter("side");
            if (currentSide.equals(configuratorSide = this.configuratorUrl.getParameter("side")) && "consumer".equals(configuratorSide) && 0 == this.configuratorUrl.getPort()) {
                url = this.configureIfMatch(NetUtils.getLocalHost(), url);
            } else if (currentSide.equals(configuratorSide) && "provider".equals(configuratorSide) && url.getPort() == this.configuratorUrl.getPort()) {
                url = this.configureIfMatch(url.getHost(), url);
            }
        } else {
            url = this.configureDeprecated(url);
        }
        return url;
    }

    @Deprecated
    private URL configureDeprecated(URL url) {
        if (this.configuratorUrl.getPort() != 0) {
            if (url.getPort() == this.configuratorUrl.getPort()) {
                return this.configureIfMatch(url.getHost(), url);
            }
        } else {
            if (url.getParameter("side", "provider").equals("consumer")) {
                return this.configureIfMatch(NetUtils.getLocalHost(), url);
            }
            if (url.getParameter("side", "consumer").equals("provider")) {
                return this.configureIfMatch("0.0.0.0", url);
            }
        }
        return url;
    }

    private URL configureIfMatch(String host, URL url) {
        String providers;
        if (("0.0.0.0".equals(this.configuratorUrl.getHost()) || host.equals(this.configuratorUrl.getHost())) && (StringUtils.isEmpty((String)(providers = this.configuratorUrl.getParameter("providerAddresses"))) || providers.contains(url.getAddress()) || providers.contains("0.0.0.0"))) {
            String configApplication = this.configuratorUrl.getParameter("application", this.configuratorUrl.getUsername());
            String currentApplication = url.getParameter("application", url.getUsername());
            if (configApplication == null || "*".equals(configApplication) || configApplication.equals(currentApplication)) {
                HashSet<String> conditionKeys = new HashSet<String>();
                conditionKeys.add("category");
                conditionKeys.add("check");
                conditionKeys.add("dynamic");
                conditionKeys.add("enabled");
                conditionKeys.add("group");
                conditionKeys.add("version");
                conditionKeys.add("application");
                conditionKeys.add("side");
                conditionKeys.add("configVersion");
                conditionKeys.add("compatible_config");
                conditionKeys.add("interfaces");
                for (Map.Entry entry : this.configuratorUrl.getParameters().entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    boolean startWithTilde = this.startWithTilde(key);
                    if (!startWithTilde && !"application".equals(key) && !"side".equals(key)) continue;
                    if (startWithTilde) {
                        conditionKeys.add(key);
                    }
                    if (value == null || "*".equals(value) || value.equals(url.getParameter(startWithTilde ? key.substring(1) : key))) continue;
                    return url;
                }
                return this.doConfigure(url, this.configuratorUrl.removeParameters(conditionKeys));
            }
        }
        return url;
    }

    private boolean startWithTilde(String key) {
        return StringUtils.isNotEmpty((String)key) && key.startsWith(TILDE);
    }

    protected abstract URL doConfigure(URL var1, URL var2);
}

