/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.testing.tools.IntegrationTestingConfig;
import org.apache.druid.testing.tools.KafkaUtil;
import org.apache.druid.testing.tools.ProtobufEventSerializer;

public class ProtobufSchemaRegistryEventSerializer
extends ProtobufEventSerializer {
    private static final int MAX_INITIALIZE_RETRIES = 10;
    public static final String TYPE = "protobuf-schema-registry";
    private final IntegrationTestingConfig config;
    private final CachedSchemaRegistryClient client;
    private int schemaId = -1;

    public ProtobufSchemaRegistryEventSerializer(String schemaRegistryHost) {
        this.config = null;
        this.client = KafkaUtil.createSchemaRegistryClient(schemaRegistryHost);
    }

    @JsonCreator
    public ProtobufSchemaRegistryEventSerializer(@JacksonInject IntegrationTestingConfig config) {
        this.config = config;
        this.client = KafkaUtil.createSchemaRegistryClient(config.getSchemaRegistryHost());
    }

    @Override
    public void initialize(String topic) {
        try {
            RetryUtils.retry(() -> {
                this.schemaId = this.client.register(topic, (ParsedSchema)new ProtobufSchema(ProtobufEventSerializer.SCHEMA.newMessageBuilder("Wikipedia").getDescriptorForType()));
                return 0;
            }, e -> true, (int)10);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public byte[] serialize(List<Pair<String, Object>> event) {
        DynamicMessage.Builder builder = SCHEMA.newMessageBuilder("Wikipedia");
        Descriptors.Descriptor msgDesc = builder.getDescriptorForType();
        for (Pair<String, Object> pair : event) {
            builder.setField(msgDesc.findFieldByName((String)pair.lhs), pair.rhs);
        }
        byte[] bytes = builder.build().toByteArray();
        ByteBuffer bb = ByteBuffer.allocate(bytes.length + 6).put((byte)0).putInt(this.schemaId).put((byte)0).put(bytes);
        bb.rewind();
        return bb.array();
    }
}

