/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.tools.IntegrationTestingConfig;

public class KafkaUtil {
    private static final String TEST_PROPERTY_PREFIX = "kafka.test.property.";
    private static final String TEST_CONFIG_PROPERTY_PREFIX = "kafka.test.config.";
    public static final String TEST_CONFIG_TRANSACTION_ENABLED = "transactionEnabled";

    public static void addPropertiesFromTestConfig(IntegrationTestingConfig config, Properties properties) {
        for (Map.Entry<String, String> entry : config.getProperties().entrySet()) {
            if (!entry.getKey().startsWith(TEST_PROPERTY_PREFIX)) continue;
            properties.setProperty(entry.getKey().substring(TEST_PROPERTY_PREFIX.length()), entry.getValue());
        }
    }

    public static Map<String, String> getAdditionalKafkaTestConfigFromProperties(IntegrationTestingConfig config) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.getProperties().entrySet()) {
            if (!entry.getKey().startsWith(TEST_CONFIG_PROPERTY_PREFIX)) continue;
            theMap.put(entry.getKey().substring(TEST_CONFIG_PROPERTY_PREFIX.length()), entry.getValue());
        }
        return theMap;
    }

    public static CachedSchemaRegistryClient createSchemaRegistryClient(String schemaRegistryHost) {
        return new CachedSchemaRegistryClient(StringUtils.format((String)"http://%s", (Object[])new Object[]{schemaRegistryHost}), Integer.MAX_VALUE, Map.of("basic.auth.credentials.source", "USER_INFO", "basic.auth.user.info", "druid:diurd"), Map.of());
    }
}

