/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import io.netty.util.SuppressForbidden;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.logger.Logger;

public class ITRetryUtil {
    private static final Logger LOG = new Logger(ITRetryUtil.class);
    public static final int DEFAULT_RETRY_COUNT = 240;
    public static final long DEFAULT_RETRY_SLEEP = TimeUnit.SECONDS.toMillis(5L);

    public static void retryUntilTrue(Callable<Boolean> callable, String task) {
        ITRetryUtil.retryUntilEquals(callable, true, task);
    }

    public static void retryUntilFalse(Callable<Boolean> callable, String task) {
        ITRetryUtil.retryUntilEquals(callable, false, task);
    }

    public static void retryUntil(Callable<Boolean> callable, boolean expectedValue, long delayInMillis, int retryCount, String taskMessage) {
        ITRetryUtil.retryUntilEquals(callable, expectedValue, delayInMillis, retryCount, taskMessage);
    }

    public static <T> void retryUntilEquals(Callable<T> callable, T expectedValue, String taskMessage) {
        ITRetryUtil.retryUntilEquals(callable, expectedValue, DEFAULT_RETRY_SLEEP, 240, taskMessage);
    }

    @SuppressForbidden(reason="System#out")
    public static <T> void retryUntilEquals(Callable<T> callable, T expectedValue, long delayInMillis, int retryCount, String taskMessage) {
        Exception lastException = null;
        Object lastValue = null;
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOG.info("Waiting until [%s] is [%s]", new Object[]{taskMessage, expectedValue});
        for (int currentTry = 0; currentTry <= retryCount; ++currentTry) {
            try {
                T currentValue = callable.call();
                if (Objects.equals(expectedValue, currentValue)) {
                    System.out.printf("Done after [%,d] millis, [%d/%d] attempts.%n", stopwatch.millisElapsed(), currentTry + 1, retryCount);
                    return;
                }
                if (!Objects.equals(lastValue, currentValue)) {
                    System.out.printf("updated to [%s]", currentValue);
                }
                System.out.print(".");
                lastValue = currentValue;
            }
            catch (Exception e) {
                lastException = e;
            }
            try {
                Thread.sleep(delayInMillis);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.printf("Retries[%d] exhausted.%n", retryCount);
        if (lastException != null) {
            throw new ISE((Throwable)lastException, "Max number of retries[%d] exceeded for Task[%s]. Failing.", new Object[]{retryCount, taskMessage});
        }
        throw new ISE("Max number of retries[%d] exceeded for Task[%s]. Failing.", new Object[]{retryCount, taskMessage});
    }
}

