/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import com.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.testing.tools.EventSerializer;

public class CsvEventSerializer
implements EventSerializer {
    public static final String TYPE = "csv";
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private final CSVWriter writer = new CSVWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)this.bos, StandardCharsets.UTF_8)));

    @Override
    public byte[] serialize(List<Pair<String, Object>> event) throws IOException {
        this.writer.writeNext((String[])event.stream().map(pair -> pair.rhs.toString()).toArray(String[]::new));
        this.writer.flush();
        byte[] serialized = this.bos.toByteArray();
        this.bos.reset();
        return serialized;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

