/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing;

import java.util.Map;

public interface DruidCommand {
    public String getName();

    public String getJavaOpts();

    public Integer[] getExposedPorts();

    public Map<String, String> getDefaultProperties();

    public static enum Server implements DruidCommand
    {
        COORDINATOR("coordinator", "-Xms128m -Xmx128m", Map.of("druid.coordinator.startDelay", "PT0.1S", "druid.coordinator.period", "PT0.5S", "druid.manager.segments.pollDuration", "PT0.1S"), 8081),
        OVERLORD("overlord", "-Xms256m -Xmx256m", Map.of("druid.indexer.storage.type", "metadata", "druid.indexer.queue.startDelay", "PT0S", "druid.indexer.queue.restartDelay", "PT0S", "druid.indexer.runner.syncRequestTimeout", "PT1S"), 8090),
        INDEXER("indexer", "-Xms128m -Xmx128m", Map.of("druid.lookup.enableLookupSyncOnStartup", "false", "druid.worker.capacity", "2", "druid.processing.buffer.sizeBytes", "50MiB", "druid.processing.numMergeBuffers", "2", "druid.processing.numThreads", "5"), 8091),
        MIDDLE_MANAGER("middleManager", "-Xms128m -Xmx128m", Map.of("druid.lookup.enableLookupSyncOnStartup", "false", "druid.worker.capacity", "2", "druid.processing.buffer.sizeBytes", "50MiB", "druid.processing.numMergeBuffers", "2", "druid.processing.numThreads", "5"), 8091, 8100, 8101),
        HISTORICAL("historical", "-Xms128m -Xmx128m", Map.of("druid.segmentCache.locations", "[{\"path\":\"/opt/druid/var/segment-cache\",\"maxSize\":\"50M\"}]", "druid.processing.buffer.sizeBytes", "10MiB", "druid.processing.numMergeBuffers", "2", "druid.processing.numThreads", "5"), 8083),
        BROKER("broker", "-Xms128m -Xmx128m", Map.of("druid.lookup.enableLookupSyncOnStartup", "false", "druid.processing.buffer.sizeBytes", "50MiB", "druid.processing.numMergeBuffers", "2", "druid.processing.numThreads", "5"), 8082),
        ROUTER("router", "-Xms128m -Xmx128m", Map.of("druid.router.managementProxy.enabled", "true"), 8888);

        private final String name;
        private final String javaOpts;
        private final Integer[] exposedPorts;
        private final Map<String, String> defaultProperties;

        private Server(String name, String javaOpts, Map<String, String> defaultProperties, Integer ... exposedPorts) {
            this.name = name;
            this.javaOpts = javaOpts;
            this.defaultProperties = defaultProperties;
            this.exposedPorts = exposedPorts;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getJavaOpts() {
            return this.javaOpts;
        }

        @Override
        public Integer[] getExposedPorts() {
            return this.exposedPorts;
        }

        @Override
        public Map<String, String> getDefaultProperties() {
            return this.defaultProperties;
        }
    }
}

