/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorCollector;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="stddev")
public class StandardDeviationPostAggregator
implements PostAggregator {
    protected final String name;
    protected final String fieldName;
    protected final String estimator;
    protected final boolean isVariancePop;

    @JsonCreator
    public StandardDeviationPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="estimator") String estimator) {
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName is null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.estimator = estimator;
        this.isVariancePop = VarianceAggregatorCollector.isVariancePop(estimator);
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    public Comparator<Double> getComparator() {
        return ArithmeticPostAggregator.DEFAULT_COMPARATOR;
    }

    @Nullable
    public Double compute(Map<String, Object> combinedAggregators) {
        Object varianceAggregatorCollector = combinedAggregators.get(this.fieldName);
        if (!(varianceAggregatorCollector instanceof VarianceAggregatorCollector)) {
            return null;
        }
        Double variance = ((VarianceAggregatorCollector)varianceAggregatorCollector).getVariance(this.isVariancePop);
        return variance == null ? null : Double.valueOf(Math.sqrt(variance));
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty(value="fieldName")
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty(value="estimator")
    public String getEstimator() {
        return this.estimator;
    }

    public String toString() {
        return "StandardDeviationPostAggregator{name='" + this.name + "', fieldName='" + this.fieldName + "', estimator='" + this.estimator + "', isVariancePop=" + this.isVariancePop + "}";
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(19).appendString(this.fieldName).appendString(this.estimator).appendBoolean(this.isVariancePop).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardDeviationPostAggregator that = (StandardDeviationPostAggregator)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.estimator, that.estimator)) {
            return false;
        }
        return Objects.equals(this.isVariancePop, that.isVariancePop);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.estimator, this.isVariancePop);
    }
}

