/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.inputsource.hdfs;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.inputsource.hdfs.HdfsInputEntity;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.utils.Streams;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class HdfsInputSource
extends AbstractInputSource
implements SplittableInputSource<List<Path>> {
    private static final String PROP_PATHS = "paths";
    private final List<String> inputPaths;
    private final Configuration configuration;
    private List<Path> cachedPaths;

    @JsonCreator
    public HdfsInputSource(@JsonProperty(value="paths") Object inputPaths, @JacksonInject @Hdfs Configuration configuration) {
        this.inputPaths = HdfsInputSource.coerceInputPathsToList(inputPaths, PROP_PATHS);
        this.configuration = configuration;
        this.cachedPaths = null;
    }

    public static List<String> coerceInputPathsToList(Object inputPaths, String propertyName) {
        List<String> paths;
        if (inputPaths instanceof String) {
            paths = Collections.singletonList((String)inputPaths);
        } else if (inputPaths instanceof List && ((List)inputPaths).stream().allMatch(x -> x instanceof String)) {
            paths = ((List)inputPaths).stream().map(x -> (String)x).collect(Collectors.toList());
        } else {
            throw new IAE("'%s' must be a string or an array of strings", new Object[]{propertyName});
        }
        return paths;
    }

    public static Collection<Path> getPaths(List<String> inputPaths, Configuration configuration) throws IOException {
        if (inputPaths.isEmpty()) {
            return Collections.emptySet();
        }
        Job job = Job.getInstance((Configuration)configuration);
        for (String inputPath : inputPaths) {
            FileInputFormat.addInputPaths((Job)job, (String)inputPath);
        }
        return new HdfsFileInputFormat().getSplits((JobContext)job).stream().filter(split -> ((FileSplit)split).getLength() > 0L).map(split -> ((FileSplit)split).getPath()).collect(Collectors.toSet());
    }

    @JsonProperty(value="paths")
    @VisibleForTesting
    List<String> getInputPaths() {
        return this.inputPaths;
    }

    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        try {
            this.cachePathsIfNeeded();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, Iterators.transform(this.cachedPaths.iterator(), path -> new HdfsInputEntity(this.configuration, (Path)path)), temporaryDirectory);
    }

    public Stream<org.apache.druid.data.input.InputSplit<List<Path>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        this.cachePathsIfNeeded();
        Iterator splitIterator = this.getSplitHintSpecOrDefault(splitHintSpec).split(this.cachedPaths.iterator(), path -> {
            try {
                long size = path.getFileSystem(this.configuration).getFileStatus(path).getLen();
                return new InputFileAttribute(size);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return Streams.sequentialStreamFrom((Iterator)splitIterator).map(org.apache.druid.data.input.InputSplit::new);
    }

    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) throws IOException {
        this.cachePathsIfNeeded();
        return this.cachedPaths.size();
    }

    public SplittableInputSource<List<Path>> withSplit(org.apache.druid.data.input.InputSplit<List<Path>> split) {
        List paths = ((List)split.get()).stream().map(path -> path.toString()).collect(Collectors.toList());
        return new HdfsInputSource(paths, this.configuration);
    }

    public boolean needsFormat() {
        return true;
    }

    private void cachePathsIfNeeded() throws IOException {
        if (this.cachedPaths == null) {
            this.cachedPaths = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(HdfsInputSource.getPaths(this.inputPaths, this.configuration), (Object)PROP_PATHS)));
        }
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private Object paths;
        private Configuration configuration;

        private Builder() {
        }

        Builder paths(Object paths) {
            this.paths = paths;
            return this;
        }

        Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        HdfsInputSource build() {
            return new HdfsInputSource(this.paths, this.configuration);
        }
    }

    private static class HdfsFileInputFormat
    extends FileInputFormat<Object, Object> {
        private HdfsFileInputFormat() {
        }

        public RecordReader<Object, Object> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
            throw new UnsupportedOperationException();
        }

        protected boolean isSplitable(JobContext context, Path filename) {
            return false;
        }
    }
}

