/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.firehose.hdfs;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.prefetch.PrefetchableTextFilesFirehoseFactory;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.inputsource.hdfs.HdfsInputSource;
import org.apache.druid.storage.hdfs.HdfsDataSegmentPuller;
import org.apache.druid.utils.CompressionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public class HdfsFirehoseFactory
extends PrefetchableTextFilesFirehoseFactory<Path> {
    private final List<String> inputPaths;
    private final Configuration conf;

    @JsonCreator
    public HdfsFirehoseFactory(@JacksonInject @Hdfs Configuration conf, @JsonProperty(value="paths") Object inputPaths, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="maxFetchRetry") Integer maxFetchRetry) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        this.inputPaths = HdfsInputSource.coerceInputPathsToList(inputPaths, "inputPaths");
        this.conf = conf;
    }

    @JsonProperty(value="paths")
    public List<String> getInputPaths() {
        return this.inputPaths;
    }

    protected Collection<Path> initObjects() throws IOException {
        return HdfsInputSource.getPaths(this.inputPaths, this.conf);
    }

    protected InputStream openObjectStream(Path path) throws IOException {
        return path.getFileSystem(this.conf).open(path);
    }

    protected InputStream openObjectStream(Path path, long start) throws IOException {
        FSDataInputStream in = path.getFileSystem(this.conf).open(path);
        in.seek(start);
        return in;
    }

    protected InputStream wrapObjectStream(Path path, InputStream stream) throws IOException {
        return CompressionUtils.decompress((InputStream)stream, (String)path.getName());
    }

    protected Predicate<Throwable> getRetryCondition() {
        return HdfsDataSegmentPuller.RETRY_PREDICATE;
    }

    public boolean isSplittable() {
        return true;
    }

    public FiniteFirehoseFactory<StringInputRowParser, Path> withSplit(InputSplit<Path> split) {
        return new HdfsFirehoseFactory(this.conf, ((Path)split.get()).toString(), this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }

    public String toString() {
        return "HdfsFirehoseFactory{inputPaths=" + this.inputPaths + '}';
    }
}

