/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchUpdater;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;

public class HllSketchBuildBufferAggregator
implements BufferAggregator {
    private final HllSketchUpdater updater;
    private final HllSketchBuildBufferAggregatorHelper helper;
    private final StringEncoding stringEncoding;

    public HllSketchBuildBufferAggregator(HllSketchUpdater updater, int lgK, TgtHllType tgtHllType, StringEncoding stringEncoding, int size) {
        this.updater = updater;
        this.helper = new HllSketchBuildBufferAggregatorHelper(lgK, tgtHllType, size);
        this.stringEncoding = stringEncoding;
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        this.updater.update(() -> this.helper.getSketchAtPosition(buf, position));
    }

    public Object get(ByteBuffer buf, int position) {
        return HllSketchHolder.of(this.helper.get(buf, position));
    }

    public void close() {
        this.helper.clear();
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        this.helper.relocate(oldPosition, newPosition, oldBuf, newBuf);
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("processor", (Object)this.updater);
        inspector.visit("lgK", (Object)this.helper.getLgK());
        inspector.visit("stringEncoding", (Object)this.stringEncoding);
    }
}

