/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta.sql;

import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;

public class ThetaPostAggMacros {
    public static final String THETA_SKETCH_ESTIMATE = "theta_sketch_estimate";

    public static class ThetaSketchEstimateExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private Expr estimateExpr;

        public ThetaSketchEstimateExpr(ThetaSketchEstimateExprMacro macro, List<Expr> args) {
            super((ExprMacroTable.ExprMacro)macro, args);
            this.estimateExpr = (Expr)Iterables.getOnlyElement(args);
        }

        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = this.estimateExpr.eval(bindings);
            Object valObj = eval.value();
            if (valObj == null) {
                return ExprEval.of(null);
            }
            if (valObj instanceof SketchHolder) {
                SketchHolder thetaSketchHolder = (SketchHolder)valObj;
                double estimate = thetaSketchHolder.getEstimate();
                return ExprEval.of((double)estimate);
            }
            throw new IllegalArgumentException("requires a ThetaSketch as the argument");
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.DOUBLE;
        }
    }

    public static class ThetaSketchEstimateExprMacro
    implements ExprMacroTable.ExprMacro {
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 1);
            return new ThetaSketchEstimateExpr(this, args);
        }

        public String name() {
            return ThetaPostAggMacros.THETA_SKETCH_ESTIMATE;
        }
    }
}

