/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import java.util.Collections;
import java.util.List;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildComplexMetricSerde;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchJsonSerializer;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeComplexMetricSerde;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToEstimatePostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToEstimateWithBoundsPostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToStringPostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchUnionPostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllPostAggExprMacros;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchApproxCountDistinctSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchApproxCountDistinctUtf8SqlAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchEstimateOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchEstimateWithErrorBoundsOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchObjectSqlAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchSetUnionOperatorConversion;
import org.apache.druid.query.aggregation.datasketches.hll.sql.HllSketchToStringOperatorConversion;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.sql.guice.SqlBindings;

public class HllSketchModule
implements DruidModule {
    public static final String TYPE_NAME = "HLLSketch";
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"HLLSketch");
    public static final String BUILD_TYPE_NAME = "HLLSketchBuild";
    public static final String MERGE_TYPE_NAME = "HLLSketchMerge";
    public static final String TO_STRING_TYPE_NAME = "HLLSketchToString";
    public static final String UNION_TYPE_NAME = "HLLSketchUnion";
    public static final String ESTIMATE_WITH_BOUNDS_TYPE_NAME = "HLLSketchEstimateWithBounds";
    public static final String ESTIMATE_TYPE_NAME = "HLLSketchEstimate";

    public void configure(Binder binder) {
        HllSketchModule.registerSerde();
        SqlBindings.addAggregator((Binder)binder, HllSketchApproxCountDistinctSqlAggregator.class);
        SqlBindings.addAggregator((Binder)binder, HllSketchApproxCountDistinctUtf8SqlAggregator.class);
        SqlBindings.addAggregator((Binder)binder, HllSketchObjectSqlAggregator.class);
        SqlBindings.addOperatorConversion((Binder)binder, HllSketchEstimateOperatorConversion.class);
        SqlBindings.addOperatorConversion((Binder)binder, HllSketchEstimateWithErrorBoundsOperatorConversion.class);
        SqlBindings.addOperatorConversion((Binder)binder, HllSketchSetUnionOperatorConversion.class);
        SqlBindings.addOperatorConversion((Binder)binder, HllSketchToStringOperatorConversion.class);
        ExpressionModule.addExprMacro((Binder)binder, HllPostAggExprMacros.HLLSketchEstimateExprMacro.class);
        SqlBindings.addApproxCountDistinctChoice((Binder)binder, (String)"APPROX_COUNT_DISTINCT_DS_HLL", HllSketchApproxCountDistinctSqlAggregator.class);
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("HllSketchModule").registerSubtypes(new NamedType[]{new NamedType(HllSketchMergeAggregatorFactory.class, MERGE_TYPE_NAME), new NamedType(HllSketchBuildAggregatorFactory.class, BUILD_TYPE_NAME), new NamedType(HllSketchMergeAggregatorFactory.class, TYPE_NAME), new NamedType(HllSketchToStringPostAggregator.class, TO_STRING_TYPE_NAME), new NamedType(HllSketchUnionPostAggregator.class, UNION_TYPE_NAME), new NamedType(HllSketchToEstimateWithBoundsPostAggregator.class, ESTIMATE_WITH_BOUNDS_TYPE_NAME), new NamedType(HllSketchToEstimatePostAggregator.class, ESTIMATE_TYPE_NAME)}).addSerializer(HllSketch.class, (JsonSerializer)new HllSketchJsonSerializer()));
    }

    @VisibleForTesting
    public static void registerSerde() {
        ComplexMetrics.registerSerde((String)TYPE_NAME, (ComplexMetricSerde)new HllSketchMergeComplexMetricSerde());
        ComplexMetrics.registerSerde((String)BUILD_TYPE_NAME, (ComplexMetricSerde)new HllSketchBuildComplexMetricSerde());
        ComplexMetrics.registerSerde((String)MERGE_TYPE_NAME, (ComplexMetricSerde)new HllSketchMergeComplexMetricSerde());
    }
}

