/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.SafeWritableMemory;

public class HllSketchHolderObjectStrategy
implements ObjectStrategy<HllSketchHolder> {
    static final HllSketchHolderObjectStrategy STRATEGY = new HllSketchHolderObjectStrategy();

    public Class<HllSketchHolder> getClazz() {
        return HllSketchHolder.class;
    }

    public int compare(HllSketchHolder sketch1, HllSketchHolder sketch2) {
        return HllSketchAggregatorFactory.COMPARATOR.compare(sketch1, sketch2);
    }

    @Nullable
    public HllSketchHolder fromByteBuffer(ByteBuffer buf, int size) {
        if (size == 0 || HllSketchHolderObjectStrategy.isSafeToConvertToNullSketch(buf, size)) {
            return null;
        }
        return HllSketchHolder.of(HllSketch.wrap((Memory)Memory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buf.position(), (long)size)));
    }

    public byte[] toBytes(HllSketchHolder holder) {
        if (holder == null) {
            return new byte[0];
        }
        HllSketch sketch = holder.getSketch();
        if (sketch == null || sketch.isEmpty()) {
            return new byte[0];
        }
        return sketch.toCompactByteArray();
    }

    @Nullable
    public HllSketchHolder fromByteBufferSafe(ByteBuffer buffer, int numBytes) {
        return HllSketchHolder.of(HllSketch.wrap((Memory)SafeWritableMemory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes)));
    }

    static boolean isSafeToConvertToNullSketch(ByteBuffer buf, int size) {
        if (size < 8) {
            return false;
        }
        int position = buf.position();
        int preInts = buf.get(position) & 0x3F;
        int curMode = buf.get(position + 7) & 3;
        switch (curMode) {
            case 0: {
                if (preInts != 2) {
                    return false;
                }
                int listCount = buf.get(position + 6) & 0xFF;
                return listCount == 0;
            }
            case 1: {
                if (preInts != 3 || size < 12) {
                    return false;
                }
                int setCount = buf.getInt(position + 8);
                return setCount == 0;
            }
            case 2: {
                if (preInts != 10) {
                    return false;
                }
                byte flags = buf.get(position + 5);
                return (flags & 4) > 0;
            }
        }
        return false;
    }
}

