/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.statsd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.timgroup.statsd.Event;
import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.druid.emitter.statsd.DimensionConverter;
import org.apache.druid.emitter.statsd.StatsDEmitterConfig;
import org.apache.druid.emitter.statsd.StatsDMetric;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

public class StatsDEmitter
implements Emitter {
    private static final Logger log = new Logger(StatsDEmitter.class);
    private static final char DRUID_METRIC_SEPARATOR = '/';
    private static final String DRUID_DEFAULT_PREFIX = "druid";
    private static final Pattern STATSD_SEPARATOR = Pattern.compile("[:|]");
    private static final Pattern BLANK = Pattern.compile("\\s+");
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final String TAG_HOSTNAME = "hostname";
    private static final String TAG_SERVICE = "druid_service";
    private static final String TAG_FEED = "feed";
    private static final String TAG_SEVERITY = "severity";
    private final StatsDClient statsd;
    private final StatsDEmitterConfig config;
    private final DimensionConverter converter;
    private final ObjectMapper mapper;

    static StatsDEmitter of(StatsDEmitterConfig config, ObjectMapper mapper) {
        NonBlockingStatsDClient client = new NonBlockingStatsDClientBuilder().prefix(config.getPrefix()).hostname(config.getHostname()).port(config.getPort()).constantTags(config.isDogstatsd() != false ? config.getDogstatsdConstantTags().toArray(new String[0]) : EMPTY_ARRAY).queueSize(config.getQueueSize().intValue()).bufferPoolSize(config.getPoolSize().intValue()).processorWorkers(config.getProcessorWorkers().intValue()).senderWorkers(config.getSenderWorkers().intValue()).errorHandler(new StatsDClientErrorHandler(){
            private int exceptionCount = 0;

            public void handle(Exception exception) {
                if (this.exceptionCount % 1000 == 0) {
                    log.error((Throwable)exception, "Error sending metric to StatsD.", new Object[0]);
                }
                ++this.exceptionCount;
            }
        }).build();
        return new StatsDEmitter(config, mapper, (StatsDClient)client);
    }

    public StatsDEmitter(StatsDEmitterConfig config, ObjectMapper mapper, StatsDClient client) {
        this.config = config;
        this.converter = new DimensionConverter(mapper, config.getDimensionMapPath());
        this.statsd = client;
        this.mapper = mapper;
    }

    public void start() {
    }

    public void emit(org.apache.druid.java.util.emitter.core.Event event) {
        if (event instanceof ServiceMetricEvent) {
            this.emitMetric((ServiceMetricEvent)event);
        } else if (event instanceof AlertEvent && this.config.isDogstatsd().booleanValue() && this.config.isDogstatsdEvents().booleanValue()) {
            this.emitAlert((AlertEvent)event);
        }
    }

    void emitMetric(ServiceMetricEvent metricEvent) {
        String host = metricEvent.getHost();
        String service = metricEvent.getService();
        String metric = metricEvent.getMetric();
        Map userDims = metricEvent.getUserDims();
        Number value = metricEvent.getValue();
        ImmutableList.Builder nameBuilder = new ImmutableList.Builder();
        ImmutableMap.Builder dimsBuilder = new ImmutableMap.Builder();
        if (this.config.isDogstatsd().booleanValue() && this.config.isDogstatsdServiceAsTag().booleanValue()) {
            dimsBuilder.put((Object)TAG_SERVICE, (Object)service);
            nameBuilder.add((Object)DRUID_DEFAULT_PREFIX);
        } else {
            nameBuilder.add((Object)service);
        }
        nameBuilder.add((Object)metric);
        StatsDMetric statsDMetric = this.converter.addFilteredUserDims(service, metric, userDims, (ImmutableMap.Builder<String, String>)dimsBuilder);
        if (statsDMetric != null) {
            String[] tags;
            ImmutableList fullNameList;
            if (this.config.isDogstatsd().booleanValue()) {
                if (this.config.getIncludeHost().booleanValue()) {
                    dimsBuilder.put((Object)TAG_HOSTNAME, (Object)host);
                }
                fullNameList = nameBuilder.build();
                tags = StatsDEmitter.tagsFromMap((Map<String, String>)dimsBuilder.build());
            } else {
                ImmutableList.Builder fullNameBuilder = new ImmutableList.Builder();
                if (this.config.getIncludeHost().booleanValue()) {
                    fullNameBuilder.add((Object)host);
                }
                fullNameBuilder.addAll((Iterable)nameBuilder.build());
                fullNameBuilder.addAll((Iterable)dimsBuilder.build().values());
                fullNameList = fullNameBuilder.build();
                tags = EMPTY_ARRAY;
            }
            String fullName = Joiner.on((String)this.config.getSeparator()).join((Iterable)fullNameList);
            fullName = StringUtils.replaceChar((String)fullName, (char)'/', (String)this.config.getSeparator());
            fullName = STATSD_SEPARATOR.matcher(fullName).replaceAll(this.config.getSeparator());
            fullName = BLANK.matcher(fullName).replaceAll(this.config.getBlankHolder());
            if (this.config.isDogstatsd().booleanValue() && (value instanceof Float || value instanceof Double)) {
                switch (statsDMetric.type) {
                    case count: {
                        this.statsd.count(fullName, value.doubleValue(), tags);
                        break;
                    }
                    case timer: {
                        this.statsd.time(fullName, value.longValue(), tags);
                        break;
                    }
                    case gauge: {
                        this.statsd.gauge(fullName, value.doubleValue(), tags);
                    }
                }
            } else {
                long val = statsDMetric.convertRange && this.config.isDogstatsd() == false ? Math.round(value.doubleValue() * 100.0) : value.longValue();
                switch (statsDMetric.type) {
                    case count: {
                        this.statsd.count(fullName, val, tags);
                        break;
                    }
                    case timer: {
                        this.statsd.time(fullName, val, tags);
                        break;
                    }
                    case gauge: {
                        this.statsd.gauge(fullName, val, tags);
                    }
                }
            }
        } else {
            log.debug("Service=[%s], Metric=[%s] has no StatsD type mapping", new Object[]{service, metric});
        }
    }

    void emitAlert(AlertEvent alertEvent) {
        Object text;
        ImmutableMap.Builder tagBuilder = ImmutableMap.builder();
        tagBuilder.put((Object)TAG_FEED, (Object)alertEvent.getFeed()).put((Object)TAG_SERVICE, (Object)alertEvent.getService()).put((Object)TAG_SEVERITY, (Object)alertEvent.getSeverity().toString());
        if (this.config.getIncludeHost().booleanValue()) {
            tagBuilder.put((Object)TAG_HOSTNAME, (Object)alertEvent.getHost());
        }
        try {
            text = this.mapper.writeValueAsString((Object)alertEvent.getDataMap());
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Unable to convert alert data to json", new Object[0]);
            text = "Unable to convert alert data to JSON: " + e.getMessage();
        }
        this.statsd.recordEvent(Event.builder().withDate(alertEvent.getCreatedTime().getMillis()).withAlertType(StatsDEmitter.alertType(alertEvent.getSeverity())).withPriority(Event.Priority.NORMAL).withTitle(alertEvent.getDescription()).withText((String)text).build(), StatsDEmitter.tagsFromMap((Map<String, String>)tagBuilder.build()));
    }

    private static String[] tagsFromMap(Map<String, String> tags) {
        return (String[])tags.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).toArray(String[]::new);
    }

    private static Event.AlertType alertType(AlertEvent.Severity severity) {
        switch (severity) {
            case ANOMALY: {
                return Event.AlertType.WARNING;
            }
            case COMPONENT_FAILURE: 
            case SERVICE_FAILURE: {
                return Event.AlertType.ERROR;
            }
        }
        return Event.AlertType.INFO;
    }

    public void flush() {
    }

    public void close() {
        this.statsd.stop();
    }
}

