/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.prometheus;

import io.prometheus.client.SimpleCollector;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.logger.Logger;
import org.joda.time.Duration;

public class DimensionsAndCollector {
    private static final Logger log = new Logger(DimensionsAndCollector.class);
    private final String[] dimensions;
    private final SimpleCollector collector;
    private final double conversionFactor;
    private final double[] histogramBuckets;
    private final ConcurrentHashMap<List<String>, Stopwatch> labelValuesToStopwatch;
    private final Duration ttlSeconds;

    DimensionsAndCollector(String[] dimensions, SimpleCollector collector, double conversionFactor, double[] histogramBuckets, @Nullable Integer ttlSeconds) {
        this.dimensions = dimensions;
        this.collector = collector;
        this.conversionFactor = conversionFactor;
        this.histogramBuckets = histogramBuckets;
        this.labelValuesToStopwatch = new ConcurrentHashMap();
        this.ttlSeconds = ttlSeconds != null ? Duration.standardSeconds((long)ttlSeconds.intValue()) : null;
    }

    public String[] getDimensions() {
        return this.dimensions;
    }

    public SimpleCollector getCollector() {
        return this.collector;
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public double[] getHistogramBuckets() {
        return this.histogramBuckets;
    }

    public void resetLastUpdateTime(List<String> labelValues) {
        if (this.ttlSeconds == null) {
            return;
        }
        this.labelValuesToStopwatch.compute(labelValues, (k, v) -> {
            if (v != null) {
                v.restart();
                return v;
            }
            return Stopwatch.createStarted();
        });
    }

    public ConcurrentMap<List<String>, Stopwatch> getLabelValuesToStopwatch() {
        return this.labelValuesToStopwatch;
    }

    public boolean shouldRemoveIfExpired(List<String> labelValues) {
        if (this.ttlSeconds == null) {
            throw DruidException.defensive((String)"Invalid usage of shouldRemoveIfExpired, ttlSeconds has not been set", (Object[])new Object[0]);
        }
        return this.labelValuesToStopwatch.computeIfPresent(labelValues, (k, v) -> {
            if (v.hasElapsed(this.ttlSeconds)) {
                return null;
            }
            return v;
        }) == null;
    }
}

