/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.prometheus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.joda.time.Duration;

public class PrometheusEmitterConfig {
    static final Pattern PATTERN = Pattern.compile("[a-zA-Z_:][a-zA-Z0-9_:]*");
    @JsonProperty
    private final Strategy strategy;
    @JsonProperty
    private final String namespace;
    @JsonProperty
    @Nullable
    private final String dimensionMapPath;
    @JsonProperty
    @Nullable
    private final Integer port;
    @JsonProperty
    @Nullable
    private final String pushGatewayAddress;
    @JsonProperty
    @Nullable
    private final Integer flushPeriod;
    @JsonProperty
    private final boolean addHostAsLabel;
    @JsonProperty
    private final boolean addServiceAsLabel;
    @JsonProperty
    private final Map<String, String> extraLabels;
    @JsonProperty
    private final boolean deletePushGatewayMetricsOnShutdown;
    @JsonProperty
    private final Duration waitForShutdownDelay;

    @JsonCreator
    public PrometheusEmitterConfig(@JsonProperty(value="strategy") @Nullable Strategy strategy, @JsonProperty(value="namespace") @Nullable String namespace, @JsonProperty(value="dimensionMapPath") @Nullable String dimensionMapPath, @JsonProperty(value="port") @Nullable Integer port, @JsonProperty(value="pushGatewayAddress") @Nullable String pushGatewayAddress, @JsonProperty(value="addHostAsLabel") boolean addHostAsLabel, @JsonProperty(value="addServiceAsLabel") boolean addServiceAsLabel, @JsonProperty(value="flushPeriod") Integer flushPeriod, @JsonProperty(value="extraLabels") @Nullable Map<String, String> extraLabels, @JsonProperty(value="deletePushGatewayMetricsOnShutdown") @Nullable Boolean deletePushGatewayMetricsOnShutdown, @JsonProperty(value="waitForShutdownDelay") @Nullable Long waitForShutdownDelay) {
        this.strategy = strategy != null ? strategy : Strategy.exporter;
        this.namespace = namespace != null ? namespace : "druid";
        Preconditions.checkArgument((boolean)PATTERN.matcher(this.namespace).matches(), (Object)("Invalid namespace " + this.namespace));
        if (strategy == Strategy.exporter) {
            Preconditions.checkArgument((port != null ? 1 : 0) != 0, (Object)"For `exporter` strategy, port must be specified.");
        } else if (this.strategy == Strategy.pushgateway) {
            Preconditions.checkArgument((pushGatewayAddress != null ? 1 : 0) != 0, (Object)"For `pushgateway` strategy, pushGatewayAddress must be specified.");
            if (Objects.nonNull(flushPeriod)) {
                Preconditions.checkArgument((flushPeriod > 0 ? 1 : 0) != 0, (Object)"flushPeriod must be greater than 0.");
            } else {
                flushPeriod = 15;
            }
        }
        this.dimensionMapPath = dimensionMapPath;
        this.port = port;
        this.pushGatewayAddress = pushGatewayAddress;
        this.flushPeriod = flushPeriod;
        this.addHostAsLabel = addHostAsLabel;
        this.addServiceAsLabel = addServiceAsLabel;
        this.extraLabels = extraLabels != null ? extraLabels : Collections.emptyMap();
        boolean bl = this.deletePushGatewayMetricsOnShutdown = deletePushGatewayMetricsOnShutdown != null && deletePushGatewayMetricsOnShutdown != false;
        if (waitForShutdownDelay == null) {
            this.waitForShutdownDelay = Duration.ZERO;
        } else if (waitForShutdownDelay >= 0L) {
            this.waitForShutdownDelay = Duration.millis((long)waitForShutdownDelay);
        } else {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build(StringUtils.format((String)"Invalid value for waitForShutdownDelay[%s] specified, waitForShutdownDelay must be >= 0.", (Object[])new Object[]{waitForShutdownDelay}), new Object[0]);
        }
        for (String key : this.extraLabels.keySet()) {
            if (PATTERN.matcher(key).matches()) continue;
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build(StringUtils.format((String)"Invalid metric label name [%s]. Label names must conform to the pattern [%s].", (Object[])new Object[]{key, PATTERN.pattern()}), new Object[0]);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDimensionMapPath() {
        return this.dimensionMapPath;
    }

    public int getPort() {
        return this.port;
    }

    public String getPushGatewayAddress() {
        return this.pushGatewayAddress;
    }

    @Nullable
    public Integer getFlushPeriod() {
        return this.flushPeriod;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public boolean isAddHostAsLabel() {
        return this.addHostAsLabel;
    }

    public boolean isAddServiceAsLabel() {
        return this.addServiceAsLabel;
    }

    public Map<String, String> getExtraLabels() {
        return this.extraLabels;
    }

    public boolean isDeletePushGatewayMetricsOnShutdown() {
        return this.deletePushGatewayMetricsOnShutdown;
    }

    public Duration getWaitForShutdownDelay() {
        return this.waitForShutdownDelay;
    }

    public static enum Strategy {
        exporter,
        pushgateway;

    }
}

