/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.prometheus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Pattern;
import org.apache.druid.emitter.prometheus.DimensionsAndCollector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class Metrics {
    private static final Logger log = new Logger(Metrics.class);
    private final Map<String, DimensionsAndCollector> registeredMetrics;
    private final ObjectMapper mapper = new ObjectMapper();
    public static final Pattern PATTERN = Pattern.compile("[^a-zA-Z_:][^a-zA-Z0-9_:]*");
    private static final String TAG_HOSTNAME = "host_name";
    private static final String TAG_SERVICE = "druid_service";

    public DimensionsAndCollector getByName(String name, String service) {
        if (this.registeredMetrics.containsKey(name)) {
            return this.registeredMetrics.get(name);
        }
        return this.registeredMetrics.getOrDefault(service + "_" + name, null);
    }

    public Metrics(String namespace, String path, boolean isAddHostAsLabel, boolean isAddServiceAsLabel, Map<String, String> extraLabels) {
        HashMap<String, DimensionsAndCollector> parsedRegisteredMetrics = new HashMap<String, DimensionsAndCollector>();
        Map<String, Metric> metrics = this.readConfig(path);
        if (extraLabels == null) {
            extraLabels = Collections.emptyMap();
        }
        for (Map.Entry<String, Metric> entry : metrics.entrySet()) {
            String name = entry.getKey();
            Metric metric = entry.getValue();
            Metric.Type type = metric.type;
            if (isAddHostAsLabel) {
                metric.dimensions.add(TAG_HOSTNAME);
            }
            if (isAddServiceAsLabel) {
                metric.dimensions.add(TAG_SERVICE);
            }
            metric.dimensions.addAll(extraLabels.keySet());
            String[] dimensions = metric.dimensions.toArray(new String[0]);
            String formattedName = PATTERN.matcher(StringUtils.toLowerCase((String)name)).replaceAll("_");
            SimpleCollector collector = null;
            if (Metric.Type.count.equals((Object)type)) {
                collector = ((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().namespace(namespace)).name(formattedName)).labelNames(dimensions)).help(metric.help)).register();
            } else if (Metric.Type.gauge.equals((Object)type)) {
                collector = ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)new Gauge.Builder().namespace(namespace)).name(formattedName)).labelNames(dimensions)).help(metric.help)).register();
            } else if (Metric.Type.timer.equals((Object)type)) {
                collector = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)new Histogram.Builder().namespace(namespace)).name(formattedName)).labelNames(dimensions)).buckets(metric.histogramBuckets).help(metric.help)).register();
            } else {
                log.error("Unrecognized metric type [%s]", new Object[]{type});
            }
            if (collector == null) continue;
            parsedRegisteredMetrics.put(name, new DimensionsAndCollector(dimensions, collector, metric.conversionFactor, metric.histogramBuckets));
        }
        this.registeredMetrics = Collections.unmodifiableMap(parsedRegisteredMetrics);
    }

    private Map<String, Metric> readConfig(String path) {
        try {
            InputStream is;
            if (Strings.isNullOrEmpty((String)path)) {
                log.info("Using default metric configuration", new Object[0]);
                is = this.getClass().getClassLoader().getResourceAsStream("defaultMetrics.json");
            } else {
                log.info("Using metric configuration at [%s]", new Object[]{path});
                is = new FileInputStream(new File(path));
            }
            return (Map)this.mapper.readerFor((TypeReference)new TypeReference<Map<String, Metric>>(){}).readValue(is);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Failed to parse metric configuration", new Object[0]);
        }
    }

    public Map<String, DimensionsAndCollector> getRegisteredMetrics() {
        return this.registeredMetrics;
    }

    public static class Metric {
        public final SortedSet<String> dimensions;
        public final Type type;
        public final String help;
        public final double conversionFactor;
        public final double[] histogramBuckets;

        @JsonCreator
        public Metric(@JsonProperty(value="dimensions") SortedSet<String> dimensions, @JsonProperty(value="type") Type type, @JsonProperty(value="help") String help, @JsonProperty(value="conversionFactor") double conversionFactor, @JsonProperty(value="histogramBuckets") List<Double> histogramBuckets) {
            this.dimensions = dimensions;
            this.type = type;
            this.help = help;
            this.conversionFactor = conversionFactor;
            this.histogramBuckets = histogramBuckets != null && !histogramBuckets.isEmpty() ? histogramBuckets.stream().mapToDouble(Double::doubleValue).toArray() : new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 30.0, 60.0, 120.0, 300.0};
        }

        public static enum Type {
            count,
            gauge,
            timer;

        }
    }
}

