/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.TopNQuery;
import org.joda.time.Interval;

public class MaterializedViewUtils {
    public static Set<String> getRequiredFields(Query query) {
        Set dimsInFilter = null == query.getFilter() ? new HashSet() : query.getFilter().getRequiredColumns();
        HashSet<String> dimensions = new HashSet<String>(dimsInFilter);
        if (query instanceof TopNQuery) {
            TopNQuery q = (TopNQuery)query;
            dimensions.addAll(MaterializedViewUtils.extractFieldsFromAggregations(q.getAggregatorSpecs()));
            dimensions.add(q.getDimensionSpec().getDimension());
        } else if (query instanceof TimeseriesQuery) {
            TimeseriesQuery q = (TimeseriesQuery)query;
            dimensions.addAll(MaterializedViewUtils.extractFieldsFromAggregations(q.getAggregatorSpecs()));
        } else if (query instanceof GroupByQuery) {
            GroupByQuery q = (GroupByQuery)query;
            dimensions.addAll(MaterializedViewUtils.extractFieldsFromAggregations(q.getAggregatorSpecs()));
            for (DimensionSpec spec : q.getDimensions()) {
                String dim = spec.getDimension();
                dimensions.add(dim);
            }
        } else {
            throw new UnsupportedOperationException("Method getRequiredFields only supports TopNQuery/TimeseriesQuery/GroupByQuery");
        }
        return dimensions;
    }

    private static Set<String> extractFieldsFromAggregations(List<AggregatorFactory> aggs) {
        HashSet<String> ret = new HashSet<String>();
        for (AggregatorFactory agg : aggs) {
            if (agg instanceof FilteredAggregatorFactory) {
                FilteredAggregatorFactory fagg = (FilteredAggregatorFactory)agg;
                ret.addAll(fagg.getFilter().getRequiredColumns());
            }
            ret.addAll(agg.requiredFields());
        }
        return ret;
    }

    public static List<Interval> minus(List<Interval> interval2, List<Interval> interval1) {
        ArrayList<Interval> remaining;
        Iterator it2;
        block15: {
            if (interval1.isEmpty() || interval2.isEmpty()) {
                return interval1;
            }
            Iterator it1 = JodaUtils.condenseIntervals(interval1).iterator();
            it2 = JodaUtils.condenseIntervals(interval2).iterator();
            remaining = new ArrayList<Interval>();
            Interval currInterval1 = (Interval)it1.next();
            Interval currInterval2 = (Interval)it2.next();
            long start1 = currInterval1.getStartMillis();
            long end1 = currInterval1.getEndMillis();
            long start2 = currInterval2.getStartMillis();
            long end2 = currInterval2.getEndMillis();
            while (true) {
                if (start2 < start1 && end2 <= start1) {
                    remaining.add(Intervals.utc((long)start2, (long)end2));
                    if (!it2.hasNext()) break block15;
                    currInterval2 = (Interval)it2.next();
                    start2 = currInterval2.getStartMillis();
                    end2 = currInterval2.getEndMillis();
                }
                if (start2 < start1 && end2 > start1 && end2 < end1) {
                    remaining.add(Intervals.utc((long)start2, (long)start1));
                    start1 = end2;
                    if (!it2.hasNext()) break block15;
                    currInterval2 = (Interval)it2.next();
                    start2 = currInterval2.getStartMillis();
                    end2 = currInterval2.getEndMillis();
                }
                if (start2 < start1 && end2 == end1) {
                    remaining.add(Intervals.utc((long)start2, (long)start1));
                    if (!it2.hasNext() || !it1.hasNext()) break block15;
                    currInterval2 = (Interval)it2.next();
                    start2 = currInterval2.getStartMillis();
                    end2 = currInterval2.getEndMillis();
                    currInterval1 = (Interval)it1.next();
                    start1 = currInterval1.getStartMillis();
                    end1 = currInterval1.getEndMillis();
                }
                if (start2 < start1 && end2 > end1) {
                    remaining.add(Intervals.utc((long)start2, (long)start1));
                    start2 = end1;
                    if (!it1.hasNext()) {
                        remaining.add(Intervals.utc((long)end1, (long)end2));
                        break block15;
                    }
                    currInterval1 = (Interval)it1.next();
                    start1 = currInterval1.getStartMillis();
                    end1 = currInterval1.getEndMillis();
                }
                if (start2 == start1 && end2 >= start1 && end2 < end1) {
                    start1 = end2;
                    if (!it2.hasNext()) break block15;
                    currInterval2 = (Interval)it2.next();
                    start2 = currInterval2.getStartMillis();
                    end2 = currInterval2.getEndMillis();
                }
                if (start2 == start1 && end2 > end1) {
                    start2 = end1;
                    if (!it1.hasNext()) {
                        remaining.add(Intervals.utc((long)end1, (long)end2));
                        break block15;
                    }
                    currInterval1 = (Interval)it1.next();
                    start1 = currInterval1.getStartMillis();
                    end1 = currInterval1.getEndMillis();
                }
                if (start2 > start1 && start2 < end1 && end2 < end1) {
                    start1 = end2;
                    if (!it2.hasNext()) break block15;
                    currInterval2 = (Interval)it2.next();
                    start2 = currInterval2.getStartMillis();
                    end2 = currInterval2.getEndMillis();
                }
                if (start2 > start1 && start2 < end1 && end2 > end1) {
                    start2 = end1;
                    if (!it1.hasNext()) {
                        remaining.add(Intervals.utc((long)end1, (long)end2));
                        break block15;
                    }
                    currInterval1 = (Interval)it1.next();
                    start1 = currInterval1.getStartMillis();
                    end1 = currInterval1.getEndMillis();
                }
                if (start2 >= start1 && start2 <= end1 && end2 == end1) {
                    if (!it2.hasNext() || !it1.hasNext()) break block15;
                    currInterval2 = (Interval)it2.next();
                    start2 = currInterval2.getStartMillis();
                    end2 = currInterval2.getEndMillis();
                    currInterval1 = (Interval)it1.next();
                    start1 = currInterval1.getStartMillis();
                    end1 = currInterval1.getEndMillis();
                }
                if (start2 < end1 || end2 <= end1) continue;
                if (!it1.hasNext()) break;
                currInterval1 = (Interval)it1.next();
                start1 = currInterval1.getStartMillis();
                end1 = currInterval1.getEndMillis();
            }
            remaining.add(Intervals.utc((long)start2, (long)end2));
        }
        while (it2.hasNext()) {
            remaining.add(Intervals.of((String)((Interval)it2.next()).toString()));
        }
        return remaining;
    }
}

