/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.materializedview.DataSourceOptimizer;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.TopNQuery;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;

public class MaterializedViewQuery<T>
implements Query<T> {
    public static final String TYPE = "view";
    private final Query query;
    private final DataSourceOptimizer optimizer;

    @JsonCreator
    public MaterializedViewQuery(@JsonProperty(value="query") Query query, @JacksonInject DataSourceOptimizer optimizer) {
        Preconditions.checkArgument((query instanceof TopNQuery || query instanceof TimeseriesQuery || query instanceof GroupByQuery ? 1 : 0) != 0, (Object)"Only topN/timeseries/groupby query are supported");
        this.query = query;
        this.optimizer = optimizer;
    }

    @JsonProperty(value="query")
    public Query getQuery() {
        return this.query;
    }

    public DataSourceOptimizer getOptimizer() {
        return this.optimizer;
    }

    public DataSource getDataSource() {
        return this.query.getDataSource();
    }

    public boolean hasFilters() {
        return this.query.hasFilters();
    }

    public DimFilter getFilter() {
        return this.query.getFilter();
    }

    public String getType() {
        return this.query.getType();
    }

    public QueryRunner<T> getRunner(QuerySegmentWalker walker) {
        return ((BaseQuery)this.query).getQuerySegmentSpec().lookup((Query)this, walker);
    }

    public List<Interval> getIntervals() {
        return this.query.getIntervals();
    }

    public Duration getDuration() {
        return this.query.getDuration();
    }

    public Granularity getGranularity() {
        return this.query.getGranularity();
    }

    public DateTimeZone getTimezone() {
        return this.query.getTimezone();
    }

    public Map<String, Object> getContext() {
        return this.query.getContext();
    }

    public Ordering<T> getResultOrdering() {
        return this.query.getResultOrdering();
    }

    public MaterializedViewQuery withOverriddenContext(Map<String, Object> contextOverride) {
        return new MaterializedViewQuery<T>(this.query.withOverriddenContext(contextOverride), this.optimizer);
    }

    public MaterializedViewQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new MaterializedViewQuery<T>(this.query.withQuerySegmentSpec(spec), this.optimizer);
    }

    public MaterializedViewQuery withId(String id) {
        return new MaterializedViewQuery<T>(this.query.withId(id), this.optimizer);
    }

    public String getId() {
        return this.query.getId();
    }

    public Query<T> withSubQueryId(String subQueryId) {
        return new MaterializedViewQuery<T>(this.query.withSubQueryId(subQueryId), this.optimizer);
    }

    @Nullable
    public String getSubQueryId() {
        return this.query.getSubQueryId();
    }

    public MaterializedViewQuery withDataSource(DataSource dataSource) {
        return new MaterializedViewQuery<T>(this.query.withDataSource(dataSource), this.optimizer);
    }

    public String toString() {
        return "MaterializedViewQuery{query=" + String.valueOf(this.query) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterializedViewQuery other = (MaterializedViewQuery)o;
        return other.getQuery().equals(this.query);
    }

    public int hashCode() {
        return Objects.hash(TYPE, this.query);
    }
}

