/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.materializedview.DataSourceOptimizerStats;
import org.apache.druid.query.materializedview.DerivativeDataSource;
import org.apache.druid.query.materializedview.DerivativeDataSourceManager;
import org.apache.druid.query.materializedview.MaterializedViewUtils;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.joda.time.Interval;

public class DataSourceOptimizer {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final TimelineServerView serverView;
    private ConcurrentHashMap<String, AtomicLong> derivativesHitCount = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> totalCount = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> hitCount = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> costTime = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<Set<String>, AtomicLong>> missFields = new ConcurrentHashMap();

    @Inject
    public DataSourceOptimizer(TimelineServerView serverView) {
        this.serverView = serverView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Query> optimize(Query query) {
        long start = System.currentTimeMillis();
        if (!(query instanceof TopNQuery) && !(query instanceof TimeseriesQuery) && !(query instanceof GroupByQuery) || !(query.getDataSource() instanceof TableDataSource)) {
            return Collections.singletonList(query);
        }
        String datasourceName = ((TableDataSource)query.getDataSource()).getName();
        ImmutableSet<DerivativeDataSource> derivatives = DerivativeDataSourceManager.getDerivatives(datasourceName);
        if (derivatives.isEmpty()) {
            return Collections.singletonList(query);
        }
        this.lock.readLock().lock();
        try {
            Object object;
            this.totalCount.computeIfAbsent(datasourceName, dsName -> new AtomicLong(0L)).incrementAndGet();
            this.hitCount.putIfAbsent(datasourceName, new AtomicLong(0L));
            AtomicLong costTimeOfDataSource = this.costTime.computeIfAbsent(datasourceName, dsName -> new AtomicLong(0L));
            Set<String> requiredFields = MaterializedViewUtils.getRequiredFields(query);
            HashSet<DerivativeDataSource> derivativesWithRequiredFields = new HashSet<DerivativeDataSource>();
            for (DerivativeDataSource derivativeDataSource : derivatives) {
                this.derivativesHitCount.putIfAbsent(derivativeDataSource.getName(), new AtomicLong(0L));
                if (!derivativeDataSource.getColumns().containsAll(requiredFields)) continue;
                derivativesWithRequiredFields.add(derivativeDataSource);
            }
            if (derivativesWithRequiredFields.isEmpty()) {
                this.missFields.computeIfAbsent(datasourceName, dsName -> new ConcurrentHashMap()).computeIfAbsent(requiredFields, rf -> new AtomicLong(0L)).incrementAndGet();
                costTimeOfDataSource.addAndGet(System.currentTimeMillis() - start);
                List<Query> list = Collections.singletonList(query);
                return list;
            }
            ArrayList<Query> queries = new ArrayList<Query>();
            List<Interval> remainingQueryIntervals = query.getIntervals();
            for (DerivativeDataSource derivativeDataSource : ImmutableSortedSet.copyOf(derivativesWithRequiredFields)) {
                TableDataSource tableDataSource = new TableDataSource(derivativeDataSource.getName());
                List<Interval> derivativeIntervals = remainingQueryIntervals.stream().flatMap(interval -> ((TimelineLookup)this.serverView.getTimeline(tableDataSource).orElseThrow(() -> new ISE("No timeline for dataSource: %s", new Object[]{derivativeDataSource.getName()}))).lookup(interval).stream().map(TimelineObjectHolder::getInterval)).collect(Collectors.toList());
                if (derivativeIntervals.isEmpty()) continue;
                remainingQueryIntervals = MaterializedViewUtils.minus(remainingQueryIntervals, derivativeIntervals);
                queries.add(query.withDataSource((DataSource)new TableDataSource(derivativeDataSource.getName())).withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec(derivativeIntervals)));
                this.derivativesHitCount.get(derivativeDataSource.getName()).incrementAndGet();
                if (!remainingQueryIntervals.isEmpty()) continue;
                break;
            }
            if (queries.isEmpty()) {
                this.costTime.get(datasourceName).addAndGet(System.currentTimeMillis() - start);
                object = Collections.singletonList(query);
                return object;
            }
            if (!remainingQueryIntervals.isEmpty()) {
                queries.add(query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)remainingQueryIntervals)));
            }
            this.hitCount.get(datasourceName).incrementAndGet();
            this.costTime.get(datasourceName).addAndGet(System.currentTimeMillis() - start);
            object = queries;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSourceOptimizerStats> getAndResetStats() {
        ImmutableMap missFieldsSnapshot;
        ImmutableMap costTimeSnapshot;
        ImmutableMap hitCountSnapshot;
        ImmutableMap totalCountSnapshot;
        ImmutableMap derivativesHitCountSnapshot;
        this.lock.writeLock().lock();
        try {
            derivativesHitCountSnapshot = ImmutableMap.copyOf(this.derivativesHitCount);
            totalCountSnapshot = ImmutableMap.copyOf(this.totalCount);
            hitCountSnapshot = ImmutableMap.copyOf(this.hitCount);
            costTimeSnapshot = ImmutableMap.copyOf(this.costTime);
            missFieldsSnapshot = ImmutableMap.copyOf(this.missFields);
            this.derivativesHitCount.clear();
            this.totalCount.clear();
            this.hitCount.clear();
            this.costTime.clear();
            this.missFields.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        ArrayList<DataSourceOptimizerStats> stats = new ArrayList<DataSourceOptimizerStats>();
        ImmutableMap<String, Set<DerivativeDataSource>> baseToDerivatives = DerivativeDataSourceManager.getAllDerivatives();
        for (Map.Entry entry : baseToDerivatives.entrySet()) {
            HashMap<String, Long> derivativesStat = new HashMap<String, Long>();
            for (DerivativeDataSource derivative : (Set)entry.getValue()) {
                derivativesStat.put(derivative.getName(), ((AtomicLong)derivativesHitCountSnapshot.getOrDefault((Object)derivative.getName(), (Object)new AtomicLong(0L))).get());
            }
            stats.add(new DataSourceOptimizerStats((String)entry.getKey(), ((AtomicLong)hitCountSnapshot.getOrDefault(entry.getKey(), (Object)new AtomicLong(0L))).get(), ((AtomicLong)totalCountSnapshot.getOrDefault(entry.getKey(), (Object)new AtomicLong(0L))).get(), ((AtomicLong)costTimeSnapshot.getOrDefault(entry.getKey(), (Object)new AtomicLong(0L))).get(), (Map)missFieldsSnapshot.getOrDefault(entry.getKey(), new ConcurrentHashMap()), derivativesStat));
        }
        return stats;
    }
}

