/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.query.materializedview.DataSourceOptimizer;
import org.apache.druid.query.materializedview.DataSourceOptimizerStats;

public class DataSourceOptimizerMonitor
extends AbstractMonitor {
    private final DataSourceOptimizer optimizer;

    @Inject
    public DataSourceOptimizerMonitor(DataSourceOptimizer optimizer) {
        this.optimizer = optimizer;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        List<DataSourceOptimizerStats> stats = this.optimizer.getAndResetStats();
        for (DataSourceOptimizerStats stat : stats) {
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            builder.setDimension("dataSource", (Object)stat.getBase());
            emitter.emit((ServiceEventBuilder)builder.setMetric("/materialized/view/query/totalNum", (Number)stat.getTotalcount()));
            emitter.emit((ServiceEventBuilder)builder.setMetric("/materialized/view/query/hits", (Number)stat.getHitcount()));
            emitter.emit((ServiceEventBuilder)builder.setMetric("/materialized/view/query/hitRate", (Number)stat.getHitRate()));
            emitter.emit((ServiceEventBuilder)builder.setMetric("/materialized/view/select/avgCostMS", (Number)stat.getOptimizerCost()));
            Map<String, Long> derivativesStats = stat.getDerivativesHitCount();
            for (Map.Entry<String, Long> derivative : derivativesStats.entrySet()) {
                builder.setDimension("derivative", (Object)derivative.getKey());
                emitter.emit((ServiceEventBuilder)builder.setMetric("/materialized/view/derivative/numSelected", (Number)derivative.getValue()));
            }
            ServiceMetricEvent.Builder builder2 = new ServiceMetricEvent.Builder();
            builder2.setDimension("dataSource", (Object)stat.getBase());
            for (Set<String> fields : stat.getMissFields().keySet()) {
                builder2.setDimension("fields", (Object)fields.toString());
                emitter.emit((ServiceEventBuilder)builder2.setMetric("/materialized/view/missNum", (Number)stat.getMissFields().get(fields).get()));
            }
        }
        return true;
    }
}

