/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.grpc.server.QueryDriver;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.http.ResultFormat;

public class ProtobufWriter
implements ResultFormat.Writer {
    private final OutputStream outputStream;
    private final GeneratedMessageV3 message;
    private Message.Builder rowBuilder;
    private final Map<String, Method> methods = new HashMap<String, Method>();

    public ProtobufWriter(OutputStream outputStream, Class<GeneratedMessageV3> clazz) {
        this.outputStream = outputStream;
        this.message = this.get(clazz);
    }

    private GeneratedMessageV3 get(Class<GeneratedMessageV3> clazz) {
        try {
            Method method = clazz.getMethod("getDefaultInstance", new Class[0]);
            return clazz.cast(method.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeResponseStart() {
    }

    public void writeHeader(RelDataType rowType, boolean includeTypes, boolean includeSqlTypes) {
    }

    public void writeHeaderFromRowSignature(RowSignature rowSignature, boolean b) {
    }

    public void writeRowStart() {
        this.rowBuilder = this.message.getDefaultInstanceForType().newBuilderForType();
    }

    public void writeRowField(String name, @Nullable Object value) {
        if (value == null) {
            return;
        }
        Descriptors.FieldDescriptor fieldDescriptor = this.message.getDescriptorForType().findFieldByName(name);
        if (fieldDescriptor == null) {
            throw new QueryDriver.RequestError("Field [%s] not found in Protobuf [%s]", name, this.message.getClass());
        }
        Method method = this.methods.computeIfAbsent("setField", k -> {
            try {
                return this.rowBuilder.getClass().getMethod("setField", Descriptors.FieldDescriptor.class, Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            method.invoke((Object)this.rowBuilder, fieldDescriptor, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new QueryDriver.RequestError("Could not write value [%s] to field [%s]", value, name);
        }
    }

    public void writeRowEnd() throws IOException {
        Message rowMessage = this.rowBuilder.build();
        rowMessage.writeDelimitedTo(this.outputStream);
    }

    public void writeResponseEnd() {
    }

    public void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }
}

