/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.druid.grpc.proto.HealthGrpc;
import org.apache.druid.grpc.proto.HealthOuterClass;

class HealthService
extends HealthGrpc.HealthImplBase {
    private final ConcurrentMap<String, HealthOuterClass.HealthCheckResponse.ServingStatus> serviceStatusMap = new ConcurrentHashMap<String, HealthOuterClass.HealthCheckResponse.ServingStatus>();
    private final ConcurrentMap<String, Context.CancellableContext> cancellationContexts = new ConcurrentHashMap<String, Context.CancellableContext>();
    private final ConcurrentMap<String, CountDownLatch> statusChangeLatchMap = new ConcurrentHashMap<String, CountDownLatch>();

    @Override
    public void check(HealthOuterClass.HealthCheckRequest request, StreamObserver<HealthOuterClass.HealthCheckResponse> responseObserver) {
        String serviceName = request.getService();
        HealthOuterClass.HealthCheckResponse.ServingStatus status = this.getServiceStatus(serviceName);
        HealthOuterClass.HealthCheckResponse response = this.buildHealthCheckResponse(status);
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    @Override
    public void watch(HealthOuterClass.HealthCheckRequest request, StreamObserver<HealthOuterClass.HealthCheckResponse> responseObserver) {
        String serviceName = request.getService();
        Context.CancellableContext existingContext = (Context.CancellableContext)this.cancellationContexts.get(serviceName);
        if (existingContext != null) {
            responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription("Another watch request is already in progress for the same service").asRuntimeException());
            return;
        }
        Context.CancellableContext cancellableContext = Context.current().withCancellation();
        this.cancellationContexts.put(serviceName, cancellableContext);
        cancellableContext.addListener(context -> this.cancellationContexts.remove(serviceName), MoreExecutors.directExecutor());
        HealthOuterClass.HealthCheckResponse.ServingStatus servingStatus = this.getServiceStatus(serviceName);
        HealthOuterClass.HealthCheckResponse initialResponse = this.buildHealthCheckResponse(servingStatus);
        responseObserver.onNext((Object)initialResponse);
        while (!cancellableContext.isCancelled()) {
            servingStatus = this.waitForServiceStatusChange(serviceName);
            HealthOuterClass.HealthCheckResponse updatedResponse = this.buildHealthCheckResponse(servingStatus);
            responseObserver.onNext((Object)updatedResponse);
        }
        this.cancellationContexts.remove(serviceName);
        responseObserver.onCompleted();
    }

    private HealthOuterClass.HealthCheckResponse buildHealthCheckResponse(HealthOuterClass.HealthCheckResponse.ServingStatus status) {
        return HealthOuterClass.HealthCheckResponse.newBuilder().setStatus(status).build();
    }

    public void registerService(String serviceName, HealthOuterClass.HealthCheckResponse.ServingStatus servingStatus) {
        this.setServiceStatus(serviceName, servingStatus);
    }

    public void unregisterService(String serviceName) {
        this.setServiceStatus(serviceName, HealthOuterClass.HealthCheckResponse.ServingStatus.NOT_SERVING);
    }

    private void setServiceStatus(String serviceName, HealthOuterClass.HealthCheckResponse.ServingStatus newStatus) {
        HealthOuterClass.HealthCheckResponse.ServingStatus currentStatus = this.getServiceStatus(serviceName);
        if (currentStatus != newStatus) {
            this.serviceStatusMap.put(serviceName, newStatus);
            CountDownLatch statusChangeLatch = (CountDownLatch)this.statusChangeLatchMap.get(serviceName);
            if (statusChangeLatch != null) {
                statusChangeLatch.countDown();
            }
        }
    }

    public HealthOuterClass.HealthCheckResponse.ServingStatus getServiceStatus(String serviceName) {
        return this.serviceStatusMap.getOrDefault(serviceName, HealthOuterClass.HealthCheckResponse.ServingStatus.UNKNOWN);
    }

    public HealthOuterClass.HealthCheckResponse.ServingStatus waitForServiceStatusChange(String serviceName) {
        CountDownLatch statusChangeLatch = new CountDownLatch(1);
        this.statusChangeLatchMap.put(serviceName, statusChangeLatch);
        try {
            statusChangeLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.statusChangeLatchMap.remove(serviceName);
        return this.getServiceStatus(serviceName);
    }
}

