/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import com.google.common.collect.ImmutableMap;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Map;
import javax.inject.Inject;
import org.apache.druid.grpc.server.QueryServer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;

public class BasicAuthServerInterceptor
implements ServerInterceptor {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BASIC_PREFIX = "Basic ";
    private static final Metadata.Key<String> AUTHORIZATION_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Logger LOG = new Logger(BasicAuthServerInterceptor.class);
    private final Authenticator authenticator;

    @Inject
    public BasicAuthServerInterceptor(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return Contexts.interceptCall((Context)Context.current().withValue(QueryServer.AUTH_KEY, (Object)this.authenticate((String)headers.get(AUTHORIZATION_KEY))), call, (Metadata)headers, next);
    }

    public AuthenticationResult authenticate(String encodedUserSecret) {
        String decodedUserSecret;
        if (encodedUserSecret == null) {
            throw new StatusRuntimeException(Status.PERMISSION_DENIED);
        }
        if (!encodedUserSecret.startsWith(BASIC_PREFIX)) {
            throw new StatusRuntimeException(Status.PERMISSION_DENIED);
        }
        encodedUserSecret = encodedUserSecret.substring(BASIC_PREFIX.length());
        try {
            decodedUserSecret = StringUtils.fromUtf8((byte[])StringUtils.decodeBase64String((String)encodedUserSecret));
        }
        catch (IllegalArgumentException iae) {
            LOG.info("Malformed user secret.", new Object[0]);
            throw new StatusRuntimeException(Status.PERMISSION_DENIED);
        }
        String[] splits = decodedUserSecret.split(":");
        if (splits.length != 2) {
            throw new StatusRuntimeException(Status.PERMISSION_DENIED);
        }
        String user = splits[0];
        String password = splits[1];
        try {
            AuthenticationResult authenticationResult = this.authenticator.authenticateJDBCContext((Map)ImmutableMap.of((Object)"user", (Object)user, (Object)"password", (Object)password));
            if (authenticationResult == null) {
                throw new StatusRuntimeException(Status.PERMISSION_DENIED);
            }
            return authenticationResult;
        }
        catch (IllegalArgumentException ex) {
            LOG.info("Exception authenticating user [%s] - [%s]", new Object[]{user, ex.getMessage()});
            throw new StatusRuntimeException(Status.PERMISSION_DENIED);
        }
    }
}

