/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.graphite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.concurrent.TimeUnit;
import org.apache.druid.emitter.graphite.DruidToGraphiteEventConverter;
import org.apache.druid.emitter.graphite.GraphiteEmitter;
import org.apache.druid.emitter.graphite.GraphiteEvent;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

@JsonTypeName(value="all")
public class SendAllGraphiteEventConverter
implements DruidToGraphiteEventConverter {
    @JsonProperty
    private final boolean ignoreHostname;
    @JsonProperty
    private final boolean ignoreServiceName;
    @JsonProperty
    private final String namespacePrefix;
    @JsonProperty
    private final boolean replaceSlashWithDot;

    @JsonProperty
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @JsonProperty
    public boolean isIgnoreServiceName() {
        return this.ignoreServiceName;
    }

    @JsonProperty
    public boolean isIgnoreHostname() {
        return this.ignoreHostname;
    }

    @JsonProperty
    public boolean replaceSlashWithDot() {
        return this.replaceSlashWithDot;
    }

    @JsonCreator
    public SendAllGraphiteEventConverter(@JsonProperty(value="namespacePrefix") String namespacePrefix, @JsonProperty(value="ignoreHostname") Boolean ignoreHostname, @JsonProperty(value="ignoreServiceName") Boolean ignoreServiceName, @JsonProperty(value="replaceSlashWithDot") Boolean replaceSlashWithDot) {
        this.ignoreHostname = ignoreHostname == null ? false : ignoreHostname;
        this.ignoreServiceName = ignoreServiceName == null ? false : ignoreServiceName;
        this.replaceSlashWithDot = replaceSlashWithDot == null ? false : replaceSlashWithDot;
        this.namespacePrefix = (String)Preconditions.checkNotNull((Object)namespacePrefix, (Object)"namespace prefix can not be null");
    }

    @Override
    public GraphiteEvent druidEventToGraphite(ServiceMetricEvent serviceMetricEvent) {
        ImmutableList.Builder metricPathBuilder = new ImmutableList.Builder();
        metricPathBuilder.add((Object)this.getNamespacePrefix());
        if (!this.isIgnoreServiceName()) {
            metricPathBuilder.add((Object)GraphiteEmitter.sanitize(serviceMetricEvent.getService()));
        }
        if (!this.isIgnoreHostname()) {
            metricPathBuilder.add((Object)GraphiteEmitter.sanitize(serviceMetricEvent.getHost()));
        }
        ImmutableSortedSet dimNames = ImmutableSortedSet.copyOf(serviceMetricEvent.getUserDims().keySet());
        for (String dimName : dimNames) {
            metricPathBuilder.add((Object)GraphiteEmitter.sanitize(String.valueOf(serviceMetricEvent.getUserDims().get(dimName))));
        }
        metricPathBuilder.add((Object)GraphiteEmitter.sanitize(serviceMetricEvent.getMetric(), this.replaceSlashWithDot()));
        return new GraphiteEvent(Joiner.on((String)".").join((Iterable)metricPathBuilder.build()), serviceMetricEvent.getValue().toString(), TimeUnit.MILLISECONDS.toSeconds(serviceMetricEvent.getCreatedTime().getMillis()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SendAllGraphiteEventConverter)) {
            return false;
        }
        SendAllGraphiteEventConverter that = (SendAllGraphiteEventConverter)o;
        if (this.isIgnoreHostname() != that.isIgnoreHostname()) {
            return false;
        }
        if (this.isIgnoreServiceName() != that.isIgnoreServiceName()) {
            return false;
        }
        if (this.replaceSlashWithDot() != that.replaceSlashWithDot()) {
            return false;
        }
        return this.getNamespacePrefix().equals(that.getNamespacePrefix());
    }

    public int hashCode() {
        int result = this.isIgnoreHostname() ? 1 : 0;
        result = 31 * result + (this.isIgnoreServiceName() ? 1 : 0);
        result = 31 * result + (this.replaceSlashWithDot() ? 1 : 0);
        result = 31 * result + this.getNamespacePrefix().hashCode();
        return result;
    }
}

