/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.graphite;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.druid.emitter.graphite.DruidToGraphiteEventConverter;
import org.apache.druid.emitter.graphite.GraphiteEmitter;
import org.apache.druid.emitter.graphite.GraphiteEvent;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

@JsonTypeName(value="whiteList")
public class WhiteListBasedConverter
implements DruidToGraphiteEventConverter {
    private static final Logger LOGGER = new Logger(WhiteListBasedConverter.class);
    private final ImmutableSortedMap<String, ImmutableSet<String>> whiteListDimsMapper;
    @JsonProperty
    private final boolean ignoreHostname;
    @JsonProperty
    private final boolean ignoreServiceName;
    @JsonProperty
    private final String namespacePrefix;
    @JsonProperty
    private final boolean replaceSlashWithDot;
    @JsonProperty
    private final String mapPath;
    private final ObjectMapper mapper;

    @JsonCreator
    public WhiteListBasedConverter(@JsonProperty(value="namespacePrefix") String namespacePrefix, @JsonProperty(value="ignoreHostname") Boolean ignoreHostname, @JsonProperty(value="ignoreServiceName") Boolean ignoreServiceName, @JsonProperty(value="replaceSlashWithDot") Boolean replaceSlashWithDot, @JsonProperty(value="mapPath") String mapPath, @JacksonInject ObjectMapper mapper) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
        this.mapPath = mapPath;
        this.whiteListDimsMapper = this.readMap(this.mapPath);
        this.ignoreHostname = ignoreHostname == null ? false : ignoreHostname;
        this.ignoreServiceName = ignoreServiceName == null ? false : ignoreServiceName;
        this.replaceSlashWithDot = replaceSlashWithDot == null ? false : replaceSlashWithDot;
        this.namespacePrefix = (String)Preconditions.checkNotNull((Object)namespacePrefix, (Object)"namespace prefix can not be null");
    }

    @JsonProperty
    public boolean isIgnoreHostname() {
        return this.ignoreHostname;
    }

    @JsonProperty
    public boolean isIgnoreServiceName() {
        return this.ignoreServiceName;
    }

    @JsonProperty
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @JsonProperty
    public boolean replaceSlashWithDot() {
        return this.replaceSlashWithDot;
    }

    private boolean isInWhiteList(ServiceMetricEvent event) {
        return this.getPrefixKey(event.getMetric(), (SortedMap<String, ?>)this.whiteListDimsMapper) != null;
    }

    private String getPrefixKey(String key, SortedMap<String, ?> whiteList) {
        String prefixKey = null;
        if (whiteList.containsKey(key)) {
            return key;
        }
        SortedMap<String, ?> headMap = whiteList.headMap(key);
        if (!headMap.isEmpty() && key.startsWith(headMap.lastKey())) {
            prefixKey = headMap.lastKey();
        }
        return prefixKey;
    }

    private List<String> getOrderedDimValues(ServiceMetricEvent event) {
        String prefixKey = this.getPrefixKey(event.getMetric(), (SortedMap<String, ?>)this.whiteListDimsMapper);
        if (prefixKey == null) {
            return null;
        }
        ImmutableList.Builder outputList = new ImmutableList.Builder();
        Set dimensions = (Set)this.whiteListDimsMapper.get((Object)prefixKey);
        if (dimensions == null) {
            return Collections.emptyList();
        }
        for (String dimKey : dimensions) {
            Collection values;
            Object rawValue = event.getUserDims().get(dimKey);
            String value = null;
            if (rawValue instanceof String) {
                value = (String)rawValue;
            } else if (rawValue instanceof Collection && !(values = (Collection)rawValue).isEmpty()) {
                value = (String)values.iterator().next();
            }
            if (value == null) continue;
            outputList.add((Object)GraphiteEmitter.sanitize(value));
        }
        return outputList.build();
    }

    @Override
    public GraphiteEvent druidEventToGraphite(ServiceMetricEvent serviceMetricEvent) {
        List<String> dimValues;
        if (!this.isInWhiteList(serviceMetricEvent)) {
            return null;
        }
        ImmutableList.Builder metricPathBuilder = new ImmutableList.Builder();
        metricPathBuilder.add((Object)this.getNamespacePrefix());
        if (!this.isIgnoreServiceName()) {
            metricPathBuilder.add((Object)GraphiteEmitter.sanitize(serviceMetricEvent.getService()));
        }
        if (!this.isIgnoreHostname()) {
            metricPathBuilder.add((Object)GraphiteEmitter.sanitize(serviceMetricEvent.getHost()));
        }
        if ((dimValues = this.getOrderedDimValues(serviceMetricEvent)) != null) {
            metricPathBuilder.addAll(dimValues);
        }
        metricPathBuilder.add((Object)GraphiteEmitter.sanitize(serviceMetricEvent.getMetric(), this.replaceSlashWithDot()));
        return new GraphiteEvent(Joiner.on((String)".").join((Iterable)metricPathBuilder.build()), String.valueOf(serviceMetricEvent.getValue()), TimeUnit.MILLISECONDS.toSeconds(serviceMetricEvent.getCreatedTime().getMillis()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WhiteListBasedConverter)) {
            return false;
        }
        WhiteListBasedConverter that = (WhiteListBasedConverter)o;
        if (this.isIgnoreHostname() != that.isIgnoreHostname()) {
            return false;
        }
        if (this.isIgnoreServiceName() != that.isIgnoreServiceName()) {
            return false;
        }
        if (this.replaceSlashWithDot() != that.replaceSlashWithDot()) {
            return false;
        }
        if (!this.getNamespacePrefix().equals(that.getNamespacePrefix())) {
            return false;
        }
        return this.mapPath != null ? this.mapPath.equals(that.mapPath) : that.mapPath == null;
    }

    public int hashCode() {
        int result = this.isIgnoreHostname() ? 1 : 0;
        result = 31 * result + (this.isIgnoreServiceName() ? 1 : 0);
        result = 31 * result + (this.replaceSlashWithDot() ? 1 : 0);
        result = 31 * result + this.getNamespacePrefix().hashCode();
        result = 31 * result + (this.mapPath != null ? this.mapPath.hashCode() : 0);
        return result;
    }

    private ImmutableSortedMap<String, ImmutableSet<String>> readMap(String mapPath) {
        String actualPath = mapPath;
        try {
            String fileContent;
            if (Strings.isNullOrEmpty((String)mapPath)) {
                URL resource = this.getClass().getClassLoader().getResource("defaultWhiteListMap.json");
                actualPath = resource.getFile();
                LOGGER.info("using default whiteList map located at [%s]", new Object[]{actualPath});
                fileContent = Resources.toString((URL)resource, (Charset)Charset.defaultCharset());
            } else {
                fileContent = Files.asCharSource((File)new File(mapPath), (Charset)StandardCharsets.UTF_8).read();
            }
            return (ImmutableSortedMap)this.mapper.readerFor((TypeReference)new TypeReference<ImmutableSortedMap<String, ImmutableSet<String>>>(){}).readValue(fileContent);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Got an exception while parsing file [%s]", new Object[]{actualPath});
        }
    }
}

