/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.graphite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.druid.emitter.graphite.DruidToGraphiteEventConverter;

public class GraphiteEmitterConfig {
    public static final String PLAINTEXT_PROTOCOL = "plaintext";
    public static final String PICKLE_PROTOCOL = "pickle";
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final long DEFAULT_FLUSH_PERIOD_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final long DEFAULT_GET_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    @JsonProperty
    private final String hostname;
    @JsonProperty
    private final int port;
    @JsonProperty
    private final int batchSize;
    @JsonProperty
    private final String protocol;
    @JsonProperty
    private final Long flushPeriod;
    @JsonProperty
    private final Integer maxQueueSize;
    @JsonProperty(value="eventConverter")
    private final DruidToGraphiteEventConverter druidToGraphiteEventConverter;
    @JsonProperty
    private final List<String> alertEmitters;
    @JsonProperty
    private final List<String> requestLogEmitters;
    @JsonProperty
    private final Long emitWaitTime;
    @JsonProperty
    private final Long waitForEventTime;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphiteEmitterConfig)) {
            return false;
        }
        GraphiteEmitterConfig that = (GraphiteEmitterConfig)o;
        if (this.getPort() != that.getPort()) {
            return false;
        }
        if (this.getBatchSize() != that.getBatchSize()) {
            return false;
        }
        if (!this.getProtocol().equals(that.getProtocol())) {
            return false;
        }
        if (!this.getHostname().equals(that.getHostname())) {
            return false;
        }
        if (!this.getFlushPeriod().equals(that.getFlushPeriod())) {
            return false;
        }
        if (!this.getMaxQueueSize().equals(that.getMaxQueueSize())) {
            return false;
        }
        if (!this.getDruidToGraphiteEventConverter().equals(that.getDruidToGraphiteEventConverter())) {
            return false;
        }
        if (this.getAlertEmitters() != null ? !this.getAlertEmitters().equals(that.getAlertEmitters()) : that.getAlertEmitters() != null) {
            return false;
        }
        if (this.getRequestLogEmitters() != null ? !this.getRequestLogEmitters().equals(that.getRequestLogEmitters()) : that.getRequestLogEmitters() != null) {
            return false;
        }
        if (!this.getEmitWaitTime().equals(that.getEmitWaitTime())) {
            return false;
        }
        return this.getWaitForEventTime().equals(that.getWaitForEventTime());
    }

    public int hashCode() {
        int result = this.getHostname().hashCode();
        result = 31 * result + this.getPort();
        result = 31 * result + this.getBatchSize();
        result = 31 * result + this.getProtocol().hashCode();
        result = 31 * result + this.getFlushPeriod().hashCode();
        result = 31 * result + this.getMaxQueueSize().hashCode();
        result = 31 * result + this.getDruidToGraphiteEventConverter().hashCode();
        result = 31 * result + (this.getAlertEmitters() != null ? this.getAlertEmitters().hashCode() : 0);
        result = 31 * result + (this.getRequestLogEmitters() != null ? this.getRequestLogEmitters().hashCode() : 0);
        result = 31 * result + this.getEmitWaitTime().hashCode();
        result = 31 * result + this.getWaitForEventTime().hashCode();
        return result;
    }

    @JsonCreator
    public GraphiteEmitterConfig(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="port") Integer port, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="protocol") String protocol, @JsonProperty(value="flushPeriod") Long flushPeriod, @JsonProperty(value="maxQueueSize") Integer maxQueueSize, @JsonProperty(value="eventConverter") DruidToGraphiteEventConverter druidToGraphiteEventConverter, @JsonProperty(value="alertEmitters") List<String> alertEmitters, @JsonProperty(value="requestLogEmitters") List<String> requestLogEmitters, @JsonProperty(value="emitWaitTime") Long emitWaitTime, @JsonProperty(value="waitForEventTime") Long waitForEventTime) {
        this.waitForEventTime = waitForEventTime == null ? DEFAULT_GET_TIMEOUT_MILLIS : waitForEventTime;
        this.emitWaitTime = emitWaitTime == null ? 0L : emitWaitTime;
        this.alertEmitters = alertEmitters == null ? Collections.emptyList() : alertEmitters;
        this.requestLogEmitters = requestLogEmitters == null ? Collections.emptyList() : requestLogEmitters;
        this.druidToGraphiteEventConverter = (DruidToGraphiteEventConverter)Preconditions.checkNotNull((Object)druidToGraphiteEventConverter, (Object)"Event converter can not ne null dude");
        this.flushPeriod = flushPeriod == null ? DEFAULT_FLUSH_PERIOD_MILLIS : flushPeriod;
        this.maxQueueSize = maxQueueSize == null ? Integer.MAX_VALUE : maxQueueSize;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname can not be null");
        this.port = (Integer)Preconditions.checkNotNull((Object)port, (Object)"port can not be null");
        this.batchSize = batchSize == null ? 100 : batchSize;
        this.protocol = protocol == null ? PICKLE_PROTOCOL : protocol;
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty
    public String getProtocol() {
        return this.protocol;
    }

    @JsonProperty
    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @JsonProperty
    public Long getFlushPeriod() {
        return this.flushPeriod;
    }

    @JsonProperty
    public DruidToGraphiteEventConverter getDruidToGraphiteEventConverter() {
        return this.druidToGraphiteEventConverter;
    }

    @JsonProperty
    public List<String> getAlertEmitters() {
        return this.alertEmitters;
    }

    @JsonProperty
    public List<String> getRequestLogEmitters() {
        return this.requestLogEmitters;
    }

    @JsonProperty
    public Long getEmitWaitTime() {
        return this.emitWaitTime;
    }

    @JsonProperty
    public Long getWaitForEventTime() {
        return this.waitForEventTime;
    }
}

