/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling.gce;

import java.util.Iterator;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;

public class GceUtils {
    public static String extractNameFromInstance(String instance) {
        String name = instance;
        if (instance != null && !instance.isEmpty()) {
            int lastSlash = instance.lastIndexOf(47);
            name = lastSlash > -1 ? instance.substring(lastSlash + 1) : instance;
        }
        return name;
    }

    public static String buildFilter(List<String> list, String key) {
        if (list == null || list.isEmpty() || key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Arguments cannot be empty of null");
        }
        Iterator<String> it = list.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.format((String)"(%s = \"%s\")", (Object[])new Object[]{key, it.next()}));
        while (it.hasNext()) {
            sb.append(" OR ").append(StringUtils.format((String)"(%s = \"%s\")", (Object[])new Object[]{key, it.next()}));
        }
        return sb.toString();
    }

    private GceUtils() {
    }
}

