/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.MapTypeMapVirtualColumnDimensionSelector;
import org.apache.druid.segment.MapVirtualColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.StringTypeMapVirtualColumnDimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;

public class MapVirtualColumn
implements VirtualColumn {
    private final String outputName;
    private final String keyDimension;
    private final String valueDimension;

    @JsonCreator
    public MapVirtualColumn(@JsonProperty(value="keyDimension") String keyDimension, @JsonProperty(value="valueDimension") String valueDimension, @JsonProperty(value="outputName") String outputName) {
        Preconditions.checkArgument((keyDimension != null ? 1 : 0) != 0, (Object)"key dimension should not be null");
        Preconditions.checkArgument((valueDimension != null ? 1 : 0) != 0, (Object)"value dimension should not be null");
        Preconditions.checkArgument((outputName != null ? 1 : 0) != 0, (Object)"output name should not be null");
        this.keyDimension = keyDimension;
        this.valueDimension = valueDimension;
        this.outputName = outputName;
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        DimensionSelector keySelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.keyDimension));
        DimensionSelector valueSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.valueDimension));
        String subColumnName = (String)VirtualColumns.splitColumnName((String)dimensionSpec.getDimension()).rhs;
        if (subColumnName == null) {
            return dimensionSpec.decorate((DimensionSelector)new MapTypeMapVirtualColumnDimensionSelector(keySelector, valueSelector));
        }
        return dimensionSpec.decorate((DimensionSelector)new StringTypeMapVirtualColumnDimensionSelector(keySelector, valueSelector, subColumnName));
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        final DimensionSelector keySelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.keyDimension));
        final DimensionSelector valueSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.valueDimension));
        final String subColumnName = (String)VirtualColumns.splitColumnName((String)columnName).rhs;
        if (subColumnName == null) {
            return new MapVirtualColumnValueSelector<Map>(keySelector, valueSelector){

                public Class<Map> classOfObject() {
                    return Map.class;
                }

                public Map getObject() {
                    IndexedInts keyIndices = keySelector.getRow();
                    IndexedInts valueIndices = valueSelector.getRow();
                    int limit = Math.min(keyIndices.size(), valueIndices.size());
                    HashMap map = Maps.newHashMapWithExpectedSize((int)limit);
                    for (int i = 0; i < limit; ++i) {
                        map.put(keySelector.lookupName(keyIndices.get(i)), valueSelector.lookupName(valueIndices.get(i)));
                    }
                    return map;
                }
            };
        }
        IdLookup keyIdLookup = keySelector.idLookup();
        if (keyIdLookup != null) {
            final int keyId = keyIdLookup.lookupId(subColumnName);
            if (keyId < 0) {
                return NilColumnValueSelector.instance();
            }
            return new MapVirtualColumnValueSelector<String>(keySelector, valueSelector){

                public Class<String> classOfObject() {
                    return String.class;
                }

                @Nullable
                public String getObject() {
                    IndexedInts keyIndices = keySelector.getRow();
                    IndexedInts valueIndices = valueSelector.getRow();
                    int limit = Math.min(keyIndices.size(), valueIndices.size());
                    for (int i = 0; i < limit; ++i) {
                        if (keyIndices.get(i) != keyId) continue;
                        return valueSelector.lookupName(valueIndices.get(i));
                    }
                    return null;
                }
            };
        }
        return new MapVirtualColumnValueSelector<String>(keySelector, valueSelector){

            public Class<String> classOfObject() {
                return String.class;
            }

            @Nullable
            public String getObject() {
                IndexedInts keyIndices = keySelector.getRow();
                IndexedInts valueIndices = valueSelector.getRow();
                int limit = Math.min(keyIndices.size(), valueIndices.size());
                for (int i = 0; i < limit; ++i) {
                    if (!Objects.equals(keySelector.lookupName(keyIndices.get(i)), subColumnName)) continue;
                    return valueSelector.lookupName(valueIndices.get(i));
                }
                return null;
            }
        };
    }

    public ColumnCapabilities capabilities(String columnName) {
        ColumnType valueType = columnName.indexOf(46) < 0 ? ColumnType.UNKNOWN_COMPLEX : ColumnType.STRING;
        return new ColumnCapabilitiesImpl().setType(valueType);
    }

    public List<String> requiredColumns() {
        return ImmutableList.of((Object)this.keyDimension, (Object)this.valueDimension);
    }

    public boolean usesDotNotation() {
        return true;
    }

    public byte[] getCacheKey() {
        byte[] key = StringUtils.toUtf8((String)this.keyDimension);
        byte[] value = StringUtils.toUtf8((String)this.valueDimension);
        byte[] output = StringUtils.toUtf8((String)this.outputName);
        return ByteBuffer.allocate(3 + key.length + value.length + output.length).put((byte)0).put(key).put((byte)-1).put(value).put((byte)-1).put(output).array();
    }

    @JsonProperty
    public String getKeyDimension() {
        return this.keyDimension;
    }

    @JsonProperty
    public String getValueDimension() {
        return this.valueDimension;
    }

    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapVirtualColumn)) {
            return false;
        }
        MapVirtualColumn that = (MapVirtualColumn)o;
        if (!this.keyDimension.equals(that.keyDimension)) {
            return false;
        }
        if (!this.valueDimension.equals(that.valueDimension)) {
            return false;
        }
        return this.outputName.equals(that.outputName);
    }

    public int hashCode() {
        int result = this.keyDimension.hashCode();
        result = 31 * result + this.valueDimension.hashCode();
        result = 31 * result + this.outputName.hashCode();
        return result;
    }

    public String toString() {
        return "MapVirtualColumn{keyDimension='" + this.keyDimension + "', valueDimension='" + this.valueDimension + "', outputName='" + this.outputName + "'}";
    }
}

