/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.movingaverage.MovingAverageQuery;

public class PostAveragerAggregatorCalculator
implements Function<Row, Row> {
    private final List<PostAggregator> postAveragers;

    public PostAveragerAggregatorCalculator(MovingAverageQuery maq) {
        this.postAveragers = maq.getPostAveragerSpecs();
    }

    public Row apply(Row row) {
        if (this.postAveragers.isEmpty()) {
            return row;
        }
        LinkedHashMap newMap = Maps.newLinkedHashMap((Map)((MapBasedRow)row).getEvent());
        for (PostAggregator postAverager : this.postAveragers) {
            boolean allColsPresent = postAverager.getDependentFields().stream().allMatch(c -> newMap.get(c) != null);
            newMap.put(postAverager.getName(), allColsPresent ? postAverager.compute((Map)newMap) : null);
        }
        return new MapBasedRow(row.getTimestamp(), (Map)newMap);
    }
}

