/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.movingaverage.AveragerFactoryWrapper;
import org.apache.druid.query.movingaverage.averagers.AveragerFactory;
import org.apache.druid.query.spec.QuerySegmentSpec;

@JsonTypeName(value="movingAverage")
public class MovingAverageQuery
extends BaseQuery<Row> {
    private static final Logger LOG = new Logger(MovingAverageQuery.class);
    public static final String MOVING_AVG_QUERY_TYPE = "movingAverage";
    public static final String CTX_KEY_SORT_BY_DIMS_FIRST = "sortByDimsFirst";
    private final LimitSpec limitSpec;
    private final HavingSpec havingSpec;
    private final DimFilter dimFilter;
    private final Granularity granularity;
    private final List<DimensionSpec> dimensions;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;
    private final List<AveragerFactory<?, ?>> averagerSpecs;
    private final List<PostAggregator> postAveragerSpecs;
    private final GroupByQuery groupByQueryForLimitSpec;
    private final Function<Sequence<ResultRow>, Sequence<ResultRow>> limitFn;

    /*
     * WARNING - void declaration
     */
    @JsonCreator
    public MovingAverageQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="dimensions") List<DimensionSpec> dimensions, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="having") HavingSpec havingSpec, @JsonProperty(value="averagers") List<AveragerFactory<?, ?>> averagerSpecs, @JsonProperty(value="postAveragers") List<PostAggregator> postAveragerSpecs, @JsonProperty(value="limitSpec") LimitSpec limitSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context);
        void var14_18;
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions == null ? ImmutableList.of() : dimensions;
        for (DimensionSpec dimensionSpec : this.dimensions) {
            Preconditions.checkArgument((dimensionSpec != null ? 1 : 0) != 0, (Object)"dimensions has null DimensionSpec");
        }
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs;
        this.averagerSpecs = averagerSpecs == null ? ImmutableList.of() : averagerSpecs;
        this.postAveragerSpecs = postAveragerSpecs == null ? ImmutableList.of() : postAveragerSpecs;
        this.havingSpec = havingSpec;
        this.limitSpec = limitSpec == null ? NoopLimitSpec.INSTANCE : limitSpec;
        Preconditions.checkNotNull((Object)this.granularity, (Object)"Must specify a granularity");
        MovingAverageQuery.verifyOutputNames(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        ArrayList<AggregatorFactory> combinedAggregatorSpecs = new ArrayList<AggregatorFactory>(this.aggregatorSpecs);
        for (AveragerFactory<?, ?> averagerFactory : this.averagerSpecs) {
            combinedAggregatorSpecs.add(new AveragerFactoryWrapper(averagerFactory, ""));
        }
        this.groupByQueryForLimitSpec = GroupByQuery.builder().setDataSource(dataSource).setInterval(this.getQuerySegmentSpec()).setDimensions(this.dimensions).setAggregatorSpecs(combinedAggregatorSpecs).setPostAggregatorSpecs((List)ImmutableList.copyOf((Iterable)Iterables.concat(this.postAggregatorSpecs, this.postAveragerSpecs))).setGranularity(this.granularity).overrideContext((Map)ImmutableMap.of((Object)CTX_KEY_SORT_BY_DIMS_FIRST, (Object)true)).build();
        Function function = this.limitSpec.build(this.groupByQueryForLimitSpec);
        if (havingSpec != null) {
            Function function2 = Functions.compose((Function)function, sequence -> Sequences.filter((Sequence)sequence, arg_0 -> ((HavingSpec)this.havingSpec).eval(arg_0)));
        }
        this.limitFn = var14_18;
    }

    private static void verifyOutputNames(List<DimensionSpec> dimensions, List<AggregatorFactory> aggregators, List<PostAggregator> postAggregators) {
        HashSet<String> outputNames = new HashSet<String>();
        for (DimensionSpec dimension : dimensions) {
            if (outputNames.add(dimension.getOutputName())) continue;
            throw new IAE("Duplicate output name[%s]", new Object[]{dimension.getOutputName()});
        }
        for (AggregatorFactory aggregator : aggregators) {
            if (outputNames.add(aggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", new Object[]{aggregator.getName()});
        }
        for (PostAggregator postAggregator : postAggregators) {
            if (outputNames.add(postAggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", new Object[]{postAggregator.getName()});
        }
    }

    private MovingAverageQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, DimFilter dimFilter, Granularity granularity, List<DimensionSpec> dimensions, List<AggregatorFactory> aggregatorSpecs, List<AveragerFactory<?, ?>> averagerSpecs, List<PostAggregator> postAggregatorSpecs, List<PostAggregator> postAveragerSpecs, HavingSpec havingSpec, LimitSpec orderBySpec, GroupByQuery groupByQueryForLimitSpec, Function<Sequence<ResultRow>, Sequence<ResultRow>> limitFn, Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions;
        this.aggregatorSpecs = aggregatorSpecs;
        this.averagerSpecs = averagerSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs;
        this.postAveragerSpecs = postAveragerSpecs;
        this.havingSpec = havingSpec;
        this.limitSpec = orderBySpec;
        this.groupByQueryForLimitSpec = groupByQueryForLimitSpec;
        this.limitFn = limitFn;
    }

    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    public String getType() {
        return MOVING_AVG_QUERY_TYPE;
    }

    @JsonIgnore
    public boolean getContextSortByDimsFirst() {
        return this.context().getBoolean(CTX_KEY_SORT_BY_DIMS_FIRST, false);
    }

    @JsonProperty
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public Granularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="averagers")
    public List<AveragerFactory<?, ?>> getAveragerSpecs() {
        return this.averagerSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @JsonProperty(value="postAveragers")
    public List<PostAggregator> getPostAveragerSpecs() {
        return this.postAveragerSpecs;
    }

    @JsonProperty(value="having")
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @JsonProperty
    public LimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    public MovingAverageQuery withOverriddenContext(Map contextOverride) {
        return new MovingAverageQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.averagerSpecs, this.postAggregatorSpecs, this.postAveragerSpecs, this.havingSpec, this.limitSpec, this.groupByQueryForLimitSpec, this.limitFn, this.computeOverridenContext(contextOverride));
    }

    public MovingAverageQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new MovingAverageQuery(this.getDataSource(), spec, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.averagerSpecs, this.postAggregatorSpecs, this.postAveragerSpecs, this.havingSpec, this.limitSpec, this.groupByQueryForLimitSpec, this.limitFn, this.getContext());
    }

    public Query<Row> withDataSource(DataSource dataSource) {
        return new MovingAverageQuery(dataSource, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.averagerSpecs, this.postAggregatorSpecs, this.postAveragerSpecs, this.havingSpec, this.limitSpec, this.groupByQueryForLimitSpec, this.limitFn, this.getContext());
    }

    public Query<Row> withPostAveragers(List<PostAggregator> postAveragerSpecs) {
        return new MovingAverageQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.averagerSpecs, this.postAggregatorSpecs, postAveragerSpecs, this.havingSpec, this.limitSpec, this.groupByQueryForLimitSpec, this.limitFn, this.getContext());
    }

    public Sequence<Row> applyLimit(Sequence<Row> results) {
        return ((Sequence)this.limitFn.apply((Object)results.map(row -> ResultRow.fromLegacyRow((Row)row, (GroupByQuery)this.groupByQueryForLimitSpec)))).map(row -> row.toMapBasedRow(this.groupByQueryForLimitSpec));
    }
}

