/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.movingaverage.MovingAverageHelper;
import org.apache.druid.query.movingaverage.RowBucket;
import org.apache.druid.query.movingaverage.averagers.Averager;
import org.apache.druid.query.movingaverage.averagers.AveragerFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;

public class MovingAverageIterable
implements Iterable<Row> {
    private final Sequence<RowBucket> seq;
    private final List<DimensionSpec> dims;
    private final List<AveragerFactory<?, ?>> factories;
    private final Map<String, PostAggregator> postAggMap;
    private final Map<String, AggregatorFactory> aggMap;
    private final Map<String, Object> emptyEvents;

    public MovingAverageIterable(Sequence<RowBucket> buckets, List<DimensionSpec> dims, List<AveragerFactory<?, ?>> factories, List<PostAggregator> postAggList, List<AggregatorFactory> aggList) {
        this.dims = dims;
        this.factories = factories;
        this.seq = buckets;
        this.postAggMap = postAggList.stream().collect(Collectors.toMap(postAgg -> postAgg.getName(), postAgg -> postAgg));
        this.aggMap = aggList.stream().collect(Collectors.toMap(agg -> agg.getName(), agg -> agg));
        this.emptyEvents = this.generateEmptyEventsFromAggregators(this.aggMap, this.postAggMap);
    }

    private Map<String, Object> generateEmptyEventsFromAggregators(Map<String, AggregatorFactory> aggMap, Map<String, PostAggregator> postAggMap) {
        LinkedHashMap<String, Object> emptyEvents = new LinkedHashMap<String, Object>();
        aggMap.values().forEach(agg -> {
            Aggregator aggFactorized = agg.factorize(this.getEmptyColumnSelectorFactory());
            emptyEvents.put(agg.getName(), aggFactorized.get());
        });
        postAggMap.values().forEach(postAgg -> emptyEvents.put(postAgg.getName(), postAgg.compute(emptyEvents)));
        return emptyEvents;
    }

    @Nonnull
    private ColumnSelectorFactory getEmptyColumnSelectorFactory() {
        return new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                return DimensionSelector.constant(null);
            }

            public ColumnValueSelector makeColumnValueSelector(String s) {
                return NilColumnValueSelector.instance();
            }

            public ColumnCapabilities getColumnCapabilities(String s) {
                return null;
            }
        };
    }

    @Override
    public Iterator<Row> iterator() {
        return new MovingAverageIterator(this.seq, this.dims, this.factories, this.emptyEvents, this.aggMap);
    }

    static class MovingAverageIterator
    implements Iterator<Row> {
        private final List<DimensionSpec> dims;
        private final Map<Map<String, Object>, List<Averager<?>>> averagers = new HashMap();
        private final List<AveragerFactory<?, ?>> averagerFactories;
        private Yielder<RowBucket> yielder;
        private RowBucket cache = null;
        private Iterator<Row> cacheIter;
        private Iterator<Map<String, Object>> averagersKeysIter;
        private Set<Map<String, Object>> seenKeys = new HashSet<Map<String, Object>>();
        private Row saveNext;
        private Map<String, AggregatorFactory> aggMap;
        private Map<String, Object> emptyEvents;

        public MovingAverageIterator(Sequence<RowBucket> rows, List<DimensionSpec> dims, List<AveragerFactory<?, ?>> averagerFactories, Map<String, Object> emptyEvents, Map<String, AggregatorFactory> aggMap) {
            this.dims = dims;
            this.averagerFactories = averagerFactories;
            this.emptyEvents = emptyEvents;
            this.aggMap = aggMap;
            this.yielder = Yielders.each(rows);
        }

        @Override
        public boolean hasNext() {
            if (this.saveNext != null) {
                return true;
            }
            this.saveNext = this.internalNext();
            return this.saveNext != null;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Row retVal = this.saveNext;
            this.saveNext = null;
            return retVal;
        }

        private Row internalNext() {
            do {
                Row r;
                if (this.cache == null && !this.yielder.isDone()) {
                    this.cache = (RowBucket)this.yielder.get();
                    this.yielder = this.yielder.next((Object)this.cache);
                    this.cacheIter = this.cache.getRows().iterator();
                }
                if (this.cacheIter != null) {
                    if (this.cacheIter.hasNext()) {
                        r = this.cacheIter.next();
                        Map<String, Object> key = MovingAverageHelper.getDimKeyFromRow(this.dims, r);
                        this.seenKeys.add(key);
                        r = this.computeMovingAverage((MapBasedRow)r, false);
                        if (r != null) {
                            return r;
                        }
                        throw new NoSuchElementException();
                    }
                    HashSet<Map<String, Object>> averagerKeys = new HashSet<Map<String, Object>>(this.averagers.keySet());
                    averagerKeys.removeAll(this.seenKeys);
                    this.averagersKeysIter = averagerKeys.iterator();
                    this.cacheIter = null;
                }
                if (this.averagersKeysIter == null) continue;
                while (this.averagersKeysIter.hasNext()) {
                    Map<String, Object> dims = this.averagersKeysIter.next();
                    HashMap<String, Object> emptyEventsCopy = new HashMap<String, Object>(this.emptyEvents);
                    dims.forEach((dim, value) -> emptyEventsCopy.put((String)dim, value));
                    r = this.computeMovingAverage(new MapBasedRow(this.cache.getDateTime(), emptyEventsCopy), true);
                    if (r == null) continue;
                    return r;
                }
                this.seenKeys.clear();
                this.averagersKeysIter = null;
                this.cache = null;
            } while (this.cacheIter != null || !this.yielder.isDone());
            return null;
        }

        @Nullable
        private Row computeMovingAverage(MapBasedRow r, boolean skip) {
            Map event = r.getEvent();
            HashMap result = new HashMap(event);
            Map<String, Object> key = MovingAverageHelper.getDimKeyFromRow(this.dims, (Row)r);
            List<Averager<Object>> avg = this.averagers.get(key);
            if (avg == null) {
                avg = this.averagerFactories.stream().map(af -> af.createAverager()).collect(Collectors.toList());
                this.averagers.put(key, avg);
            }
            if (!skip) {
                avg.forEach(af -> af.addElement(event, this.aggMap));
            } else {
                avg.forEach(af -> af.skip());
            }
            avg.forEach(af -> result.put(af.getName(), af.getResult()));
            if (result.entrySet().stream().anyMatch(e -> !key.containsKey(e.getKey()) && e.getValue() != null)) {
                result.putAll(event);
                return new MapBasedRow(r.getTimestamp(), result);
            }
            return null;
        }
    }
}

