/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class DoubleMeanNoNullAverager
extends BaseAverager<Number, Double> {
    public DoubleMeanNoNullAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Double computeResult() {
        double result = 0.0;
        int validBuckets = 0;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            if (((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] == null) continue;
            result += ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].doubleValue();
            ++validBuckets;
        }
        ++this.startFrom;
        return result / (double)validBuckets;
    }
}

