/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class LongSumAverager
extends BaseAverager<Number, Long> {
    public LongSumAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Long computeResult() {
        long result = 0L;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            if (((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] != null) {
                result += ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].longValue();
                continue;
            }
            result += 0L;
        }
        ++this.startFrom;
        return result;
    }
}

