/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class LongMeanNoNullAverager
extends BaseAverager<Number, Double> {
    public LongMeanNoNullAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Double computeResult() {
        long result = 0L;
        int validBuckets = 0;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            if (((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] == null) continue;
            result += ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].longValue();
            ++validBuckets;
        }
        ++this.startFrom;
        return (double)result / (double)validBuckets;
    }
}

