/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.query.movingaverage.BucketingAccumulator;
import org.apache.druid.query.movingaverage.RowBucket;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class RowBucketIterable
implements Iterable<RowBucket> {
    public final Sequence<Row> seq;
    private List<Interval> intervals;
    private Period period;

    public RowBucketIterable(Sequence<Row> seq, List<Interval> intervals, Period period) {
        this.seq = seq;
        this.period = period;
        this.intervals = intervals;
    }

    @Override
    public Iterator<RowBucket> iterator() {
        return new RowBucketIterator(this.seq, this.intervals, this.period);
    }

    static class RowBucketIterator
    implements Iterator<RowBucket> {
        private Yielder<RowBucket> yielder;
        private DateTime endTime;
        private DateTime expectedBucket;
        private Period period;
        private int intervalIndex = 0;
        private List<Interval> intervals;
        private boolean processedLastRow = false;
        private boolean processedExtraRow = false;

        public RowBucketIterator(Sequence<Row> rows, List<Interval> intervals, Period period) {
            this.period = period;
            this.intervals = intervals;
            this.expectedBucket = intervals.get(this.intervalIndex).getStart();
            this.endTime = intervals.get(intervals.size() - 1).getEnd();
            this.yielder = rows.toYielder(null, (YieldingAccumulator)new BucketingAccumulator());
        }

        @Override
        public boolean hasNext() {
            return this.expectedBucket.compareTo((ReadableInstant)this.endTime) < 0 || !this.yielder.isDone();
        }

        @Override
        public RowBucket next() {
            RowBucket currentBucket = (RowBucket)this.yielder.get();
            if (this.expectedBucket.compareTo((ReadableInstant)this.intervals.get(this.intervalIndex).getEnd()) >= 0) {
                ++this.intervalIndex;
                if (this.intervalIndex < this.intervals.size()) {
                    this.expectedBucket = this.intervals.get(this.intervalIndex).getStart();
                }
            }
            if (currentBucket != null && currentBucket.getDateTime().compareTo((ReadableInstant)this.expectedBucket) > 0) {
                currentBucket = new RowBucket(this.expectedBucket, Collections.emptyList());
                this.expectedBucket = this.expectedBucket.plus((ReadablePeriod)this.period);
                return currentBucket;
            }
            if (!this.yielder.isDone()) {
                this.yielder = this.yielder.next((Object)currentBucket);
                this.expectedBucket = this.expectedBucket.plus((ReadablePeriod)this.period);
                return currentBucket;
            }
            if (!this.processedLastRow && this.yielder.get() != null && ((RowBucket)this.yielder.get()).getNextBucket() == null) {
                this.processedLastRow = true;
                this.expectedBucket = this.expectedBucket.plus((ReadablePeriod)this.period);
                return currentBucket;
            }
            if (!this.processedExtraRow && this.yielder.get() != null && ((RowBucket)this.yielder.get()).getNextBucket() != null) {
                RowBucket lastRow = ((RowBucket)this.yielder.get()).getNextBucket();
                if (lastRow.getDateTime().compareTo((ReadableInstant)this.expectedBucket) > 0) {
                    lastRow = new RowBucket(this.expectedBucket, Collections.emptyList());
                    this.expectedBucket = this.expectedBucket.plus((ReadablePeriod)this.period);
                    return lastRow;
                }
                this.processedExtraRow = true;
                this.expectedBucket = this.expectedBucket.plus((ReadablePeriod)this.period);
                return lastRow;
            }
            if (this.expectedBucket.compareTo((ReadableInstant)this.endTime) < 0) {
                currentBucket = new RowBucket(this.expectedBucket, Collections.emptyList());
                this.expectedBucket = this.expectedBucket.plus((ReadablePeriod)this.period);
                return currentBucket;
            }
            throw new NoSuchElementException();
        }
    }
}

