/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.movingaverage.MovingAverageIterable;
import org.apache.druid.query.movingaverage.MovingAverageQuery;
import org.apache.druid.query.movingaverage.PostAveragerAggregatorCalculator;
import org.apache.druid.query.movingaverage.RowBucket;
import org.apache.druid.query.movingaverage.RowBucketIterable;
import org.apache.druid.query.movingaverage.averagers.AveragerFactory;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class MovingAverageQueryRunner
implements QueryRunner<Row> {
    private final QuerySegmentWalker walker;
    private final RequestLogger requestLogger;

    public MovingAverageQueryRunner(@Nullable QuerySegmentWalker walker, RequestLogger requestLogger) {
        this.walker = walker;
        this.requestLogger = requestLogger;
    }

    public Sequence<Row> run(QueryPlus<Row> query, ResponseContext responseContext) {
        Sequence resultsSeq;
        MovingAverageQuery maq = (MovingAverageQuery)query.getQuery();
        Optional<Integer> opt = maq.getAveragerSpecs().stream().map(AveragerFactory::getNumBuckets).max(Integer::compare);
        int buckets = opt.orElse(0);
        if (!(maq.getGranularity() instanceof PeriodGranularity)) {
            throw new ISE("Only PeriodGranulaity is supported for movingAverage queries", new Object[0]);
        }
        Period period = ((PeriodGranularity)maq.getGranularity()).getPeriod();
        int offset = buckets <= 0 ? 0 : 1 - buckets;
        List<Interval> intervals = maq.getIntervals().stream().map(i -> new Interval((ReadableInstant)i.getStart().withPeriodAdded((ReadablePeriod)period, offset), (ReadableInstant)i.getEnd())).collect(Collectors.toList());
        DataSource dataSource = maq.getDataSource();
        if (maq.getDimensions() != null && !maq.getDimensions().isEmpty() && (dataSource instanceof TableDataSource || dataSource instanceof UnionDataSource || dataSource instanceof QueryDataSource)) {
            GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource(dataSource).setInterval(intervals).setDimFilter(maq.getFilter()).setGranularity(maq.getGranularity()).setDimensions(maq.getDimensions()).setAggregatorSpecs(maq.getAggregatorSpecs()).setPostAggregatorSpecs(maq.getPostAggregatorSpecs()).setContext(maq.getContext());
            GroupByQuery gbq = builder.build();
            ResponseContext gbqResponseContext = ResponseContext.createEmpty();
            gbqResponseContext.merge(responseContext);
            gbqResponseContext.putQueryFailDeadlineMs(System.currentTimeMillis() + gbq.context().getTimeout());
            Sequence results = gbq.getRunner(this.walker).run(QueryPlus.wrap((Query)gbq), gbqResponseContext);
            try {
                this.requestLogger.logNativeQuery(RequestLogLine.forNative((Query)gbq, (DateTime)DateTimes.nowUtc(), (String)"127.0.0.1", (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)0, (Object)"query/bytes", (Object)0, (Object)"success", (Object)true))));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            resultsSeq = results.map(row -> row.toMapBasedRow(gbq));
        } else {
            TimeseriesQuery tsq = new TimeseriesQuery(dataSource, (QuerySegmentSpec)new MultipleIntervalSegmentSpec(intervals), false, null, maq.getFilter(), maq.getGranularity(), maq.getAggregatorSpecs(), maq.getPostAggregatorSpecs(), 0, maq.getContext());
            ResponseContext tsqResponseContext = ResponseContext.createEmpty();
            tsqResponseContext.merge(responseContext);
            tsqResponseContext.putQueryFailDeadlineMs(System.currentTimeMillis() + tsq.context().getTimeout());
            Sequence results = tsq.getRunner(this.walker).run(QueryPlus.wrap((Query)tsq), tsqResponseContext);
            try {
                this.requestLogger.logNativeQuery(RequestLogLine.forNative((Query)tsq, (DateTime)DateTimes.nowUtc(), (String)"127.0.0.1", (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)0, (Object)"query/bytes", (Object)0, (Object)"success", (Object)true))));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            resultsSeq = Sequences.map((Sequence)results, (Function)new TimeseriesResultToRow());
        }
        Sequence bucketedMovingAvgResults = Sequences.simple((Iterable)new RowBucketIterable((Sequence<Row>)resultsSeq, intervals, period));
        Sequence<Row> movingAvgResults = Sequences.simple((Iterable)new MovingAverageIterable((Sequence<RowBucket>)bucketedMovingAvgResults, maq.getDimensions(), maq.getAveragerSpecs(), maq.getPostAggregatorSpecs(), maq.getAggregatorSpecs()));
        Sequence movingAvgResultsWithPostAveragers = Sequences.map((Sequence)movingAvgResults, (Function)new PostAveragerAggregatorCalculator(maq));
        List reportingIntervals = maq.getIntervals();
        movingAvgResults = Sequences.filter((Sequence)movingAvgResultsWithPostAveragers, row -> reportingIntervals.stream().anyMatch(i -> i.contains((ReadableInstant)row.getTimestamp())));
        movingAvgResults = maq.applyLimit(movingAvgResults);
        return movingAvgResults;
    }

    static class TimeseriesResultToRow
    implements Function<Result<TimeseriesResultValue>, Row> {
        TimeseriesResultToRow() {
        }

        public Row apply(Result<TimeseriesResultValue> lookbackResult) {
            Map event = ((TimeseriesResultValue)lookbackResult.getValue()).getBaseObject();
            MapBasedRow row = new MapBasedRow(lookbackResult.getTimestamp(), event);
            return row;
        }
    }
}

